/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.kmeans;

import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.utils.Utils;
import gnu.trove.iterator.TLongIntIterator;
import gnu.trove.map.hash.TLongDoubleHashMap;
import java.util.Map;
import java.util.TreeMap;

public class SequencekMeansCentroid {
    private TLongDoubleHashMap kmerValues = null;
    private int[] ranks = null;

    public SequencekMeansCentroid(Sequence read) {
        this.initKmerValues();
        this.addWith(read);
    }

    public void initRanks(Map<Long, Integer> spaceRanks) {
        int spaceSize = spaceRanks.size();
        this.ranks = new int[spaceSize];
        TreeMap<Long, Double> unsorted = new TreeMap<Long, Double>();
        for (long kmerCode : this.getKmerCodes()) {
            unsorted.put(kmerCode, this.getValueForKmerCode(kmerCode));
        }
        Object object = spaceRanks.keySet().iterator();
        while (object.hasNext()) {
            long kmerCode = (Long)object.next();
            if (unsorted.containsKey(kmerCode)) continue;
            unsorted.put(kmerCode, 0.0);
        }
        Map sorted = Utils.sortByValue(unsorted);
        int current = 0;
        for (Map.Entry entry : sorted.entrySet()) {
            this.ranks[spaceRanks.get(entry.getKey()).intValue()] = current++;
        }
        unsorted.clear();
        sorted.clear();
        unsorted = null;
        sorted = null;
    }

    public int[] getRanks() {
        return this.ranks;
    }

    public void initKmerValues() {
        this.kmerValues = new TLongDoubleHashMap();
    }

    public long[] getKmerCodes() {
        return this.kmerValues.keys();
    }

    public double getValueForKmerCode(long kmerCode) {
        return this.kmerValues.get(kmerCode);
    }

    public void insertKmerValue(long kmerCode, double value) {
        if (kmerCode < 0L) {
            return;
        }
        this.kmerValues.adjustOrPutValue(kmerCode, value, value);
    }

    public void clear() {
        if (this.kmerValues != null) {
            this.kmerValues.clear();
            this.kmerValues = null;
        }
    }

    public void addWith(Sequence other) {
        TLongIntIterator it = other.iteratorCounts();
        while (it.hasNext()) {
            it.advance();
            this.insertKmerValue(it.key(), it.value());
        }
    }

    public void divideWith(double div) {
        for (long kmerCode : this.getKmerCodes()) {
            this.kmerValues.put(kmerCode, this.kmerValues.get(kmerCode) / div);
        }
    }

    public static double distanceSpearman(SequencekMeansCentroid center, Sequence read, Map<Long, Integer> spaceRanks) {
        double distance = 0.0;
        int spaceSize = spaceRanks.size();
        for (int i = 0; i < spaceSize; ++i) {
            distance += (double)Math.abs(center.getRanks()[i] - read.getRanks()[i]);
        }
        return distance;
    }

    public static double distanceEuclid(SequencekMeansCentroid center, Sequence read, Map<Long, Integer> spaceRanks) {
        double sumSquared = 0.0;
        for (long kmerCode : spaceRanks.keySet()) {
            double v = (double)read.getCountForKmerCode(kmerCode) - center.getValueForKmerCode(kmerCode);
            sumSquared += v * v;
        }
        return Math.sqrt(sumSquared);
    }
}

