/*
 * Decompiled with CFR 0.152.
 */
package fr.cea.ig.metatarget.kmeans;

import fr.cea.ig.metatarget.datastructures.Sequence;
import fr.cea.ig.metatarget.kmeans.ClusterVectorCB;
import fr.cea.ig.metatarget.kmeans.SequencekMeansCentroid;
import fr.cea.ig.metatarget.utils.Coder;
import fr.cea.ig.metatarget.utils.Utils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.TreeMap;
import java.util.concurrent.BrokenBarrierException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;

public class ConcurrentKMeans
implements Runnable {
    private ProtoCluster[] mProtoClusters;
    private double[][] mDistanceCache;
    private int[] mClusterAssignments;
    private List<Sequence> mSequences;
    private int mK;
    private int mMaxIterations;
    private long mRandomSeed;
    private int mThreadCount;
    private SubtaskManager mSubtaskManager;
    private ClusterVectorCB[] mClusters;
    private CountDownLatch startSignal = null;
    private CountDownLatch doneSignal = null;
    private static Map<Long, Integer> spaceRanks = null;
    private static int numOfClustersCB;
    private static int kCB;

    public ConcurrentKMeans(int numOfClustersCB, int kCB, List<Sequence> sequences, int maxIterations, long randomSeed, int threadCount, CountDownLatch startSignal, CountDownLatch doneSignal) {
        ConcurrentKMeans.numOfClustersCB = numOfClustersCB;
        ConcurrentKMeans.kCB = kCB;
        this.mSequences = sequences;
        this.mK = Math.min(ConcurrentKMeans.numOfClustersCB, this.mSequences.size());
        this.mMaxIterations = maxIterations;
        this.mRandomSeed = randomSeed;
        this.mThreadCount = threadCount;
        this.startSignal = startSignal;
        this.doneSignal = doneSignal;
        spaceRanks = new TreeMap<Long, Integer>();
        int rank = 0;
        ArrayList<String> allKmers = Utils.generateKmerVocabulary(ConcurrentKMeans.kCB);
        for (String kmerS : allKmers) {
            spaceRanks.put(Coder.encodeToLong(kmerS, ConcurrentKMeans.kCB), rank++);
        }
    }

    public ClusterVectorCB[] getClusters() {
        return this.mClusters;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            this.startSignal.await();
            long startTime = System.currentTimeMillis();
            System.out.println("K-Means clustering started");
            this.initCenters();
            System.out.println("... centers initialized");
            this.mSubtaskManager = new SubtaskManager(this.mThreadCount);
            System.out.println("... concurrent processing mode with " + this.mThreadCount + " subtask threads");
            this.computeDistances();
            this.makeAssignments();
            int moves = 0;
            int it = 0;
            do {
                this.computeCenters();
                this.computeDistances();
                moves = this.makeAssignments();
                System.out.println("... iteration " + ++it + " moves = " + moves);
            } while (moves > 0 && it < this.mMaxIterations);
            this.mClusters = this.generateFinalClusters();
            long executionTime = System.currentTimeMillis() - startTime;
            System.out.println("...end.\t" + (double)executionTime / 1000.0 + " seconds.");
            this.finalDistances();
            this.doneSignal.countDown();
        }
        catch (Throwable t) {
            System.out.println("ERROR1");
            System.out.println(t.getMessage());
            System.out.println(t.getStackTrace()[0].toString());
        }
        finally {
            this.cleanup();
        }
    }

    private void finalDistances() {
        for (int i = 0; i < this.mSequences.size(); ++i) {
            double[] distances = new double[numOfClustersCB];
            for (int c = 0; c < numOfClustersCB; ++c) {
                distances[c] = this.mDistanceCache[i][c];
            }
            this.mSequences.get(i).setDistancesToClusters(distances);
        }
    }

    private void initCenters() {
        int i;
        Random random = new Random(this.mRandomSeed);
        int sequenceCount = this.mSequences.size();
        if (this.mClusterAssignments == null) {
            this.mClusterAssignments = new int[sequenceCount];
            Arrays.fill(this.mClusterAssignments, -1);
        }
        int[] indices = new int[sequenceCount];
        for (i = 0; i < sequenceCount; ++i) {
            indices[i] = i;
        }
        i = 0;
        for (int m = sequenceCount; m > 0; --m) {
            int j = i + random.nextInt(m);
            if (i != j) {
                int n = i;
                indices[n] = indices[n] ^ indices[j];
                int n2 = j;
                indices[n2] = indices[n2] ^ indices[i];
                int n3 = i;
                indices[n3] = indices[n3] ^ indices[j];
            }
            ++i;
        }
        this.mProtoClusters = new ProtoCluster[this.mK];
        for (i = 0; i < this.mK; ++i) {
            int readIndex = indices[i];
            this.mProtoClusters[i] = new ProtoCluster(new SequencekMeansCentroid(this.mSequences.get(readIndex)), readIndex);
            this.mProtoClusters[i].mCenter.initRanks(spaceRanks);
            this.mClusterAssignments[indices[i]] = i;
        }
    }

    private void computeCenters() {
        for (ProtoCluster cluster : this.mProtoClusters) {
            if (!cluster.getConsiderForAssignment()) continue;
            if (!cluster.isEmpty()) {
                cluster.setUpdateFlag();
                if (!cluster.needsUpdate()) continue;
                cluster.updateCenter(this.mSequences);
                continue;
            }
            cluster.setConsiderForAssignment(false);
        }
    }

    private void computeDistances() {
        int numSequences = this.mSequences.size();
        int numClusters = this.mProtoClusters.length;
        if (this.mDistanceCache == null) {
            this.mDistanceCache = new double[numSequences][numClusters];
        }
        this.mSubtaskManager.computeDistances();
    }

    private int makeAssignments() {
        int numClusters = this.mProtoClusters.length;
        for (int c = 0; c < numClusters; ++c) {
            if (!this.mProtoClusters[c].getConsiderForAssignment()) continue;
            this.mProtoClusters[c].checkPoint();
        }
        this.mSubtaskManager.makeAssignments();
        return this.mSubtaskManager.numberOfMoves();
    }

    private int nearestCluster(int ndx) {
        int nearest = -1;
        double min = Double.MAX_VALUE;
        int numClusters = this.mProtoClusters.length;
        for (int c = 0; c < numClusters; ++c) {
            double d;
            if (!this.mProtoClusters[c].getConsiderForAssignment() || !((d = this.mDistanceCache[ndx][c]) < min)) continue;
            min = d;
            nearest = c;
        }
        return nearest;
    }

    private ClusterVectorCB[] generateFinalClusters() {
        int numClusters = this.mProtoClusters.length;
        ArrayList<ClusterVectorCB> clusterList = new ArrayList<ClusterVectorCB>(numClusters);
        for (int c = 0; c < numClusters; ++c) {
            ProtoCluster pcluster = this.mProtoClusters[c];
            if (pcluster.isEmpty()) continue;
            ClusterVectorCB cluster = new ClusterVectorCB(pcluster.getMembership(), pcluster.getCenter());
            clusterList.add(cluster);
        }
        ClusterVectorCB[] clusters = new ClusterVectorCB[clusterList.size()];
        clusterList.toArray(clusters);
        return clusters;
    }

    private void cleanup() {
        System.out.println(Utils.time() + " : kMeans cleanup.");
        this.mProtoClusters = null;
        this.mDistanceCache = null;
        this.mClusterAssignments = null;
        if (this.mSubtaskManager != null) {
            this.mSubtaskManager.shutdown();
            this.mSubtaskManager = null;
        }
    }

    private static class ProtoCluster {
        private int[] mPreviousMembership;
        private int[] mCurrentMembership;
        private int mCurrentSize;
        private SequencekMeansCentroid mCenter;
        private boolean mUpdateFlag = true;
        private boolean mConsiderForAssignment = true;

        ProtoCluster(SequencekMeansCentroid center, int readIndex) {
            this.mCenter = center;
            this.mPreviousMembership = new int[0];
            this.mCurrentMembership = new int[10];
            this.mCurrentSize = 0;
            this.add(readIndex);
        }

        int[] getMembership() {
            this.trimCurrentMembership();
            return this.mCurrentMembership;
        }

        SequencekMeansCentroid getCenter() {
            return this.mCenter;
        }

        void trimCurrentMembership() {
            if (this.mCurrentMembership.length > this.mCurrentSize) {
                int[] temp = new int[this.mCurrentSize];
                System.arraycopy(this.mCurrentMembership, 0, temp, 0, this.mCurrentSize);
                this.mCurrentMembership = temp;
            }
        }

        synchronized void add(int ndx) {
            if (this.mCurrentSize == this.mCurrentMembership.length) {
                int newCapacity = Math.max(10, 2 * this.mCurrentMembership.length);
                int[] temp = new int[newCapacity];
                System.arraycopy(this.mCurrentMembership, 0, temp, 0, this.mCurrentSize);
                this.mCurrentMembership = temp;
            }
            this.mCurrentMembership[this.mCurrentSize++] = ndx;
        }

        boolean isEmpty() {
            return this.mCurrentSize == 0;
        }

        void setUpdateFlag() {
            this.trimCurrentMembership();
            Arrays.sort(this.mCurrentMembership);
            this.mUpdateFlag = false;
            if (this.mPreviousMembership.length == this.mCurrentSize) {
                for (int i = 0; i < this.mCurrentSize; ++i) {
                    if (this.mPreviousMembership[i] == this.mCurrentMembership[i]) continue;
                    this.mUpdateFlag = true;
                    break;
                }
            } else {
                this.mUpdateFlag = true;
            }
        }

        void checkPoint() {
            this.mPreviousMembership = this.mCurrentMembership;
            this.mCurrentMembership = new int[10];
            this.mCurrentSize = 0;
        }

        boolean getConsiderForAssignment() {
            return this.mConsiderForAssignment;
        }

        void setConsiderForAssignment(boolean b) {
            this.mConsiderForAssignment = b;
        }

        boolean needsUpdate() {
            return this.mUpdateFlag;
        }

        void updateCenter(List<Sequence> sequences) {
            this.mCenter.initKmerValues();
            if (this.mCurrentSize > 0) {
                for (int i = 0; i < this.mCurrentSize; ++i) {
                    Sequence sequence = sequences.get(this.mCurrentMembership[i]);
                    this.mCenter.addWith(sequence);
                }
                this.mCenter.divideWith(this.mCurrentSize);
            }
            this.mCenter.initRanks(spaceRanks);
        }
    }

    private class SubtaskManager {
        static final int DOING_NOTHING = 0;
        static final int COMPUTING_DISTANCES = 1;
        static final int MAKING_ASSIGNMENTS = 2;
        private int mDoing = 0;
        private boolean mWorking;
        private Executor mExecutor;
        private CyclicBarrier mBarrier;
        private Worker[] mWorkers;

        SubtaskManager(int numThreads) {
            if (numThreads <= 0) {
                throw new IllegalArgumentException("number of threads <= 0: " + numThreads);
            }
            int sequenceCount = ConcurrentKMeans.this.mSequences.size();
            if (numThreads > sequenceCount) {
                numThreads = sequenceCount;
            }
            this.mWorkers = new Worker[numThreads];
            int[] sequencesPerWorker = new int[numThreads];
            Arrays.fill(sequencesPerWorker, sequenceCount / numThreads);
            int leftOvers = sequenceCount - numThreads * sequencesPerWorker[0];
            int i = 0;
            while (i < leftOvers) {
                int n = i++;
                sequencesPerWorker[n] = sequencesPerWorker[n] + 1;
            }
            int startRead = 0;
            for (int i2 = 0; i2 < numThreads; ++i2) {
                this.mWorkers[i2] = new Worker(startRead, sequencesPerWorker[i2]);
                startRead += sequencesPerWorker[i2];
            }
            if (numThreads == 1) {
                this.mExecutor = new Executor(){

                    @Override
                    public void execute(Runnable runnable) {
                        if (Thread.interrupted()) {
                            throw new RejectedExecutionException("RejectedExecutionException");
                        }
                        runnable.run();
                    }
                };
            } else {
                this.mBarrier = new CyclicBarrier(numThreads, new Runnable(){

                    @Override
                    public void run() {
                        SubtaskManager.this.workersDone();
                    }
                });
                this.mExecutor = Executors.newFixedThreadPool(numThreads);
            }
        }

        boolean makeAssignments() {
            this.mDoing = 2;
            return this.work();
        }

        boolean computeDistances() {
            this.mDoing = 1;
            return this.work();
        }

        private boolean work() {
            boolean ok = false;
            this.mWorking = true;
            try {
                if (this.mBarrier != null) {
                    this.mBarrier.reset();
                }
                for (int i = 0; i < this.mWorkers.length; ++i) {
                    this.mExecutor.execute(this.mWorkers[i]);
                }
                if (this.mBarrier != null) {
                    this.waitOnWorkers();
                    ok = !this.mBarrier.isBroken();
                } else {
                    ok = true;
                }
            }
            catch (RejectedExecutionException ree) {
                ree.printStackTrace();
            }
            finally {
                this.mWorking = false;
            }
            return ok;
        }

        private synchronized void waitOnWorkers() {
            while (this.mWorking) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    break;
                }
            }
        }

        private synchronized void workersDone() {
            this.mWorking = false;
            this.notifyAll();
        }

        void shutdown() {
            if (this.mExecutor instanceof ThreadPoolExecutor) {
                ((ThreadPoolExecutor)this.mExecutor).shutdownNow();
            }
        }

        int numberOfMoves() {
            int moves = 0;
            for (int i = 0; i < this.mWorkers.length; ++i) {
                moves += this.mWorkers[i].numberOfMoves();
            }
            return moves;
        }

        private class Worker
        implements Runnable {
            private int mStartRead;
            private int mNumSequences;
            private int mMoves;

            Worker(int startRead, int NumSequences) {
                this.mStartRead = startRead;
                this.mNumSequences = NumSequences;
            }

            int numberOfMoves() {
                return this.mMoves;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                try {
                    switch (SubtaskManager.this.mDoing) {
                        case 1: {
                            this.workerComputeDistances();
                            return;
                        }
                        case 2: {
                            this.workerMakeAssignments();
                            return;
                        }
                    }
                    return;
                }
                finally {
                    if (SubtaskManager.this.mBarrier != null) {
                        try {
                            SubtaskManager.this.mBarrier.await();
                        }
                        catch (InterruptedException interruptedException) {
                        }
                        catch (BrokenBarrierException brokenBarrierException) {}
                    }
                }
            }

            private void workerComputeDistances() {
                int lim = this.mStartRead + this.mNumSequences;
                for (int i = this.mStartRead; i < lim; ++i) {
                    int numClusters = ConcurrentKMeans.this.mProtoClusters.length;
                    for (int c = 0; c < numClusters; ++c) {
                        double distance;
                        ProtoCluster cluster = ConcurrentKMeans.this.mProtoClusters[c];
                        if (!cluster.getConsiderForAssignment() || !cluster.needsUpdate()) continue;
                        ((Sequence)ConcurrentKMeans.this.mSequences.get(i)).initRanks(spaceRanks);
                        ((ConcurrentKMeans)ConcurrentKMeans.this).mDistanceCache[i][c] = distance = SequencekMeansCentroid.distanceSpearman(cluster.getCenter(), (Sequence)ConcurrentKMeans.this.mSequences.get(i), spaceRanks);
                    }
                }
            }

            private void workerMakeAssignments() {
                this.mMoves = 0;
                int lim = this.mStartRead + this.mNumSequences;
                for (int i = this.mStartRead; i < lim; ++i) {
                    int c = ConcurrentKMeans.this.nearestCluster(i);
                    ConcurrentKMeans.this.mProtoClusters[c].add(i);
                    if (ConcurrentKMeans.this.mClusterAssignments[i] == c) continue;
                    ((ConcurrentKMeans)ConcurrentKMeans.this).mClusterAssignments[i] = c;
                    ++this.mMoves;
                }
            }
        }
    }
}

