## ----style, echo=FALSE, results='hide', message=FALSE-------------------------
library(BiocStyle)
library(knitr)
opts_chunk$set(error = FALSE, message = FALSE, warning = FALSE, echo = TRUE)

## ----eval = FALSE-------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# BiocManager::install("islify")

## -----------------------------------------------------------------------------
library(islify)
data(posImage)
data(negImage)

## -----------------------------------------------------------------------------
quantIntensities <- getQuantileIntensities(list(posImage),
    quantiles = c(0.9, 0.95, 0.99)
)
quantIntensities

## ----eval=FALSE---------------------------------------------------------------
# saveImage(list(posImage, negImage), c("pos", "neg"),
#     frameNums = "All",
#     frameCols = c("R", "G", "B"), truncTo =
#         quantIntensities[[1]][, "Percent_95"],
#     outDir = "."
# )

## -----------------------------------------------------------------------------
sizeCutoff <- getSizeCutoff(imgDirs = list(negImage, posImage), frameNum = 3)
sizeCutoff

## -----------------------------------------------------------------------------
intensityCutoffRed <- getIntensityCutoff(
    imgDirs = list(negImage, posImage),
    frameNum = 1,
    ignore_white =
        quantIntensities[[1]][, "Percent_90"][1]
)
intensityCutoffRed

## -----------------------------------------------------------------------------
intensityCutoffGreen <- getIntensityCutoff(
    imgDirs = list(posImage),
    frameNum = 2,
    ignore_white =
        quantIntensities[[1]][, "Percent_90"][2]
)
intensityCutoffGreen

## ----eval=FALSE---------------------------------------------------------------
# result <- islify(
#     imgDirs = list(negImage, posImage),
#     imgNames = c("Neg", "Pos"),
#     frameNumFocus = 1,
#     sizeCutoff = sizeCutoff,
#     intensityCutoffFocus =
#         intensityCutoffRed,
#     truncLim =
#         quantIntensities[[1]][, "Percent_95"][1]
# )

## ----echo=FALSE---------------------------------------------------------------
result <- islify(
    imgDirs = list(negImage, posImage),
    imgNames = c("Neg", "Pos"),
    frameNumFocus = 1,
    sizeCutoff = sizeCutoff,
    intensityCutoffFocus =
        intensityCutoffRed,
    diagnoImgs = FALSE
)

## -----------------------------------------------------------------------------
result

## ----eval=FALSE---------------------------------------------------------------
# result <- islify(
#     imgDirs = list(negImage, posImage),
#     imgNames = c("Neg", "Pos"),
#     frameNumFocus = 1,
#     frameNumReference = 2,
#     sizeCutoff = sizeCutoff,
#     intensityCutoffFocus =
#         intensityCutoffRed,
#     intensityCutoffReference =
#         intensityCutoffGreen,
#     truncLim =
#         quantIntensities[[1]][, "Percent_95"][1]
# )

## ----echo=FALSE---------------------------------------------------------------
result <- islify(
    imgDirs = list(negImage, posImage),
    imgNames = c("Neg", "Pos"),
    frameNumFocus = 1,
    frameNumReference = 2,
    sizeCutoff = sizeCutoff,
    intensityCutoffFocus =
        intensityCutoffRed,
    intensityCutoffReference =
        intensityCutoffGreen,
    truncLim =
        quantIntensities[[1]][, "Percent_95"][1],
    diagnoImgs = FALSE
)

## -----------------------------------------------------------------------------
result

## -----------------------------------------------------------------------------
sessionInfo()

