/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.sim;

import edu.rit.sim.Event;

public class Simulation {
    private Event[] heap = new Event[1024];
    private int N = 1;
    private double T = 0.0;

    public Simulation() {
        this.heap[0] = new Event(){

            public void perform() {
            }
        };
        this.heap[0].sim = this;
        this.heap[0].time = 0.0;
    }

    public double time() {
        return this.T;
    }

    public void doAt(double d, Event event) {
        if (d < this.T) {
            throw new IllegalArgumentException("Simulation.doAt(): t = " + d + " less than simulation time =" + this.T + ", illegal");
        }
        if (event == null) {
            throw new NullPointerException("Simulation.doAt(): event = null");
        }
        event.sim = this;
        event.time = d;
        if (this.N == this.heap.length) {
            Event[] eventArray = new Event[this.N + 1024];
            System.arraycopy(this.heap, 0, eventArray, 0, this.N);
            this.heap = eventArray;
        }
        this.heap[this.N] = event;
        this.siftUp(this.N);
        ++this.N;
    }

    public void doAfter(double d, Event event) {
        this.doAt(this.T + d, event);
    }

    public void run() {
        while (this.N > 1) {
            Event event = this.heap[1];
            --this.N;
            this.heap[1] = this.heap[this.N];
            this.heap[this.N] = null;
            if (this.N > 1) {
                this.siftDown(1);
            }
            this.T = event.time;
            event.perform();
        }
    }

    private void siftUp(int n) {
        double d = this.heap[n].time;
        int n2 = n >> 1;
        double d2 = this.heap[n2].time;
        while (d < d2) {
            Event event = this.heap[n];
            this.heap[n] = this.heap[n2];
            this.heap[n2] = event;
            n = n2;
            n2 = n >> 1;
            d2 = this.heap[n2].time;
        }
    }

    private void siftDown(int n) {
        double d;
        int n2;
        double d2;
        double d3 = this.heap[n].time;
        int n3 = n << 1;
        double d4 = n3 < this.N ? this.heap[n3].time : Double.POSITIVE_INFINITY;
        int n4 = (n << 1) + 1;
        double d5 = d2 = n4 < this.N ? this.heap[n4].time : Double.POSITIVE_INFINITY;
        if (d4 < d2) {
            n2 = n3;
            d = d4;
        } else {
            n2 = n4;
            d = d2;
        }
        while (d < d3) {
            Event event = this.heap[n2];
            this.heap[n2] = this.heap[n];
            this.heap[n] = event;
            n = n2;
            n3 = n << 1;
            d4 = n3 < this.N ? this.heap[n3].time : Double.POSITIVE_INFINITY;
            n4 = (n << 1) + 1;
            double d6 = d2 = n4 < this.N ? this.heap[n4].time : Double.POSITIVE_INFINITY;
            if (d4 < d2) {
                n2 = n3;
                d = d4;
                continue;
            }
            n2 = n4;
            d = d2;
        }
    }
}

