/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.numeric;

import edu.rit.numeric.ArraySeries;
import edu.rit.numeric.Series;
import edu.rit.numeric.XYSeries;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class ArrayXYSeries
extends XYSeries
implements Externalizable {
    private static final long serialVersionUID = 4402374363889012094L;
    private double[] xarray;
    private double[] yarray;

    public ArrayXYSeries() {
    }

    public ArrayXYSeries(double[] dArray, double[] dArray2) {
        if (dArray == null) {
            throw new NullPointerException("ArrayXYSeries(): xarray is null");
        }
        if (dArray2 == null) {
            throw new NullPointerException("ArrayXYSeries(): yarray is null");
        }
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("ArrayXYSeries(): xarray length (= " + dArray.length + ") != yarray length (= " + dArray2.length + "), illegal");
        }
        this.xarray = dArray;
        this.yarray = dArray2;
    }

    public int length() {
        return this.xarray.length;
    }

    public double x(int n) {
        return this.xarray[n];
    }

    public double y(int n) {
        return this.yarray[n];
    }

    public Series xSeries() {
        return new ArraySeries(this.xarray);
    }

    public Series ySeries() {
        return new ArraySeries(this.yarray);
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        int n = this.xarray.length;
        objectOutput.writeInt(n);
        for (int i = 0; i < n; ++i) {
            objectOutput.writeDouble(this.xarray[i]);
            objectOutput.writeDouble(this.yarray[i]);
        }
    }

    public void readExternal(ObjectInput objectInput) throws IOException {
        int n = objectInput.readInt();
        this.xarray = new double[n];
        this.yarray = new double[n];
        for (int i = 0; i < n; ++i) {
            this.xarray[i] = objectInput.readDouble();
            this.yarray[i] = objectInput.readDouble();
        }
    }
}

