/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.image.test;

import edu.rit.image.PJGGrayImage;
import edu.rit.image.PJGImage;
import edu.rit.numeric.BigRational;
import edu.rit.util.Hex;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class Test02 {
    static final BigRational ZERO = new BigRational("0");
    static final BigRational ONE = new BigRational("1");
    static final BigRational ONE_THIRD = new BigRational("1/3");
    static int C;
    static int S;
    static BigRational A;
    static BigRational B;
    static File filename;
    static BigRational[] currCell;
    static BigRational[] nextCell;
    static byte[][] matrix;
    static PJGGrayImage image;
    static byte[][] matrix2;
    static PJGGrayImage image2;

    private Test02() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object object;
        int n;
        if (stringArray.length != 3) {
            Test02.usage();
        }
        C = Integer.parseInt(stringArray[1]);
        S = Integer.parseInt(stringArray[0]) - 1;
        A = ONE_THIRD;
        B = new BigRational("9/10");
        filename = new File(stringArray[2]);
        currCell = new BigRational[C];
        nextCell = new BigRational[C];
        for (n = 0; n < C; ++n) {
            Test02.currCell[n] = new BigRational();
            Test02.nextCell[n] = new BigRational();
        }
        currCell[C / 2].assign(ONE);
        matrix = new byte[S + 1][C];
        image = new PJGGrayImage(S + 1, C, matrix);
        image.setInterpretation(PJGGrayImage.ZERO_IS_WHITE);
        for (n = 0; n < S; ++n) {
            for (int i = 0; i < C; ++i) {
                nextCell[i].assign(currCell[i]).add(currCell[(i - 1 + C) % C]).add(currCell[(i + 1) % C]).mul(A).add(B).normalize().fracPart();
            }
            Test02.writeCurrCell(n);
            object = currCell;
            currCell = nextCell;
            nextCell = object;
        }
        Test02.writeCurrCell(S);
        PJGImage.Writer writer = image.prepareToWrite(new BufferedOutputStream(new FileOutputStream(filename)));
        writer.write();
        writer.close();
        image2 = new PJGGrayImage();
        object = image2.prepareToRead(new BufferedInputStream(new FileInputStream(filename)));
        ((PJGImage.Reader)object).read();
        ((PJGImage.Reader)object).close();
        matrix2 = image2.getMatrix();
        for (int i = 0; i <= S; ++i) {
            byte[] byArray = matrix[i];
            byte[] byArray2 = matrix2[i];
            for (int j = 0; j < C; ++j) {
                if (byArray[j] == byArray2[j]) continue;
                System.out.print("matrix[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(byArray[j]));
                System.out.print(", matrix2[");
                System.out.print(i);
                System.out.print("][");
                System.out.print(j);
                System.out.print("] = ");
                System.out.print(Hex.toString(byArray2[j]));
                System.out.println();
            }
        }
    }

    private static void writeCurrCell(int n) throws IOException {
        for (int i = 0; i < C; ++i) {
            image.setPixel(n, i, currCell[i].floatValue());
        }
    }

    private static void usage() {
        System.err.println("Usage: java edu.rit.image.test.Test02 <height> <width> <filename>");
        System.err.println("<height> = Image height (pixels)");
        System.err.println("<width> = Image width (pixels)");
        System.err.println("<filename> = PJG image file name");
        System.exit(1);
    }
}

