## ----eval=FALSE---------------------------------------------------------------
#     if (!requireNamespace("BiocManager", quietly = TRUE))
#         install.packages("BiocManager")
#     BiocManager::install("GrafGen")

## -----------------------------------------------------------------------------
library(GrafGen)

## -----------------------------------------------------------------------------
    dir <- system.file("extdata", package="GrafGen", mustWork=TRUE)
    geno.file <- paste0(dir, .Platform$file.sep, "data.vcf.gz")
    print(geno.file)

## -----------------------------------------------------------------------------
ret <- grafGen(geno.file, print=0)
ret$table[seq_len(5), ]

## -----------------------------------------------------------------------------
print(ret)

## ----crop=NULL----------------------------------------------------------------
plot(ret)

## -----------------------------------------------------------------------------
if (interactive()) interactiveReferencePlot()

## -----------------------------------------------------------------------------
tmp <- createApp(ret)
if (interactive()) {
    reference_results <- tmp$reference_results
    user_results      <- tmp$user_results
    user_metadata     <- tmp$user_metadata
    shiny::runApp(tmp$app)
}

## -----------------------------------------------------------------------------
sessionInfo()

