/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.file;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bridgedb.AbstractIDMapperCapabilities;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperCapabilities;
import org.bridgedb.IDMapperException;
import org.bridgedb.Xref;
import org.bridgedb.file.IDMappingReader;
import org.bridgedb.impl.InternalUtils;

public abstract class IDMapperFile
implements IDMapper {
    protected final IDMapperFileCapabilities cap;
    protected final IDMappingReader reader;
    private boolean isConnected = true;

    public IDMapperFile(IDMappingReader reader) throws IDMapperException {
        this(reader, false);
    }

    public IDMapperFile(IDMappingReader reader, boolean freeSearch) throws IDMapperException {
        if (reader == null) {
            throw new IllegalArgumentException("reader cannot be null.");
        }
        this.reader = reader;
        this.cap = new IDMapperFileCapabilities(freeSearch);
    }

    @Override
    public Map<Xref, Set<Xref>> mapID(Collection<Xref> srcXrefs, DataSource ... tgtDataSources) throws IDMapperException {
        HashSet<DataSource> tgtDss;
        if (srcXrefs == null) {
            throw new NullPointerException("argument srcXrefs cannot be null");
        }
        HashMap<Xref, Set<Xref>> result = new HashMap<Xref, Set<Xref>>();
        Set<DataSource> supportedTgtDatasources = this.cap.getSupportedTgtDataSources();
        if (tgtDataSources.length == 0) {
            tgtDss = new HashSet<DataSource>(this.cap.getSupportedTgtDataSources());
        } else {
            tgtDss = new HashSet<DataSource>(Arrays.asList(tgtDataSources));
            tgtDss.retainAll(supportedTgtDatasources);
        }
        if (tgtDss.isEmpty()) {
            return result;
        }
        Map<Xref, Set<Xref>> mapXrefs = this.reader.getIDMappings();
        if (mapXrefs == null) {
            return result;
        }
        Set<DataSource> supportedSrcDatasources = this.cap.getSupportedSrcDataSources();
        for (Xref srcXref : srcXrefs) {
            Set<Xref> refs;
            if (!supportedSrcDatasources.contains(srcXref.getDataSource()) || (refs = mapXrefs.get(srcXref)) == null) continue;
            for (Xref tgtXref : refs) {
                if (tgtDataSources.length != 0 && !tgtDss.contains(tgtXref.getDataSource())) continue;
                InternalUtils.multiMapPut(result, srcXref, tgtXref);
            }
        }
        return result;
    }

    @Override
    public Set<Xref> mapID(Xref srcXref, DataSource ... tgtDataSources) throws IDMapperException {
        Map<Xref, Set<Xref>> mapXrefs = this.reader.getIDMappings();
        HashSet<Xref> result = new HashSet<Xref>();
        if (mapXrefs == null) {
            return result;
        }
        HashSet<DataSource> tgtDss = new HashSet<DataSource>(Arrays.asList(tgtDataSources));
        Set<Xref> destRefs = mapXrefs.get(srcXref);
        if (destRefs != null) {
            for (Xref destRef : mapXrefs.get(srcXref)) {
                if (tgtDataSources.length != 0 && !tgtDss.contains(destRef.getDataSource())) continue;
                result.add(destRef);
            }
        }
        return result;
    }

    @Override
    public boolean xrefExists(Xref xref) throws IDMapperException {
        if (xref == null) {
            throw new NullPointerException();
        }
        Map<Xref, Set<Xref>> mapXrefs = this.reader.getIDMappings();
        if (mapXrefs == null) {
            return false;
        }
        return mapXrefs.containsKey(xref);
    }

    @Override
    public void close() throws IDMapperException {
        this.isConnected = false;
    }

    @Override
    public boolean isConnected() {
        return this.isConnected;
    }

    @Override
    public IDMapperCapabilities getCapabilities() {
        return this.cap;
    }

    protected IDMappingReader getIDMappingReader() {
        return this.reader;
    }

    private class IDMapperFileCapabilities
    extends AbstractIDMapperCapabilities {
        public IDMapperFileCapabilities(boolean freeSearch) throws IDMapperException {
            super(IDMapperFile.this.reader.getDataSources(), false, null);
        }
    }
}

