/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.vcf;

import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Map;
import java.util.function.Function;

public class SNPEncoder {
    public static final Function<String, byte[][]> StringToByteMatrixParser = line -> (byte[][])Arrays.stream(line.split("\t", -1)).map(field -> field.getBytes(StandardCharsets.UTF_8)).toArray(x$0 -> new byte[x$0][]);
    public static final Function<String, String> StringToStringParser = line -> line;

    public static int[][] encodeSNPOneHot(String snpLine, int ploidy, int maxAlleles, Map<String, int[]> encodingCache, int numSamples) throws IllegalArgumentException {
        int fieldEnd;
        int[][] encoded = new int[numSamples][];
        int expectedColumns = numSamples + 9;
        int fieldStart = 0;
        int col = 0;
        String[] fields = new String[expectedColumns];
        while ((fieldEnd = snpLine.indexOf(9, fieldStart)) != -1 && col < expectedColumns) {
            fields[col++] = snpLine.substring(fieldStart, fieldEnd);
            fieldStart = fieldEnd + 1;
        }
        fields[col] = snpLine.substring(fieldStart);
        String formatString = fields[8];
        int gtIndex = -1;
        int fieldIdx = 0;
        int pos = 0;
        while (formatString != null && pos < formatString.length()) {
            String token;
            int sep = formatString.indexOf(58, pos);
            if (sep == -1) {
                sep = formatString.length();
            }
            if ((token = formatString.substring(pos, sep)).equals("GT")) {
                gtIndex = fieldIdx;
                break;
            }
            pos = sep + 1;
            ++fieldIdx;
        }
        if (gtIndex == -1) {
            throw new IllegalArgumentException("FORMAT field does not contain GT");
        }
        for (int i = 0; i < numSamples; ++i) {
            String sampleField = fields[i + 9];
            String[] sampleParts = sampleField.split(":");
            if (gtIndex >= sampleParts.length) continue;
            String genotype = sampleParts[gtIndex];
            int[] encoding = encodingCache.computeIfAbsent(genotype, g -> SNPEncoder.encodeGenotypeOneHot(g, ploidy, maxAlleles));
            encoded[i] = encoding;
        }
        return encoded;
    }

    public static int[] encodeGenotypeOneHot(String genotype, int ploidy, int maxAlleles) {
        int totalBits = ploidy * maxAlleles;
        int numInts = (totalBits + 31) / 32;
        int[] oneHot = new int[numInts];
        if (genotype == null || genotype.equals(".") || genotype.contains(".")) {
            return oneHot;
        }
        String[] alleles = genotype.split("[/|]");
        for (int i = 0; i < ploidy && i < alleles.length; ++i) {
            try {
                int allele = Integer.parseInt(alleles[i]);
                if (allele < 0 || allele >= maxAlleles) continue;
                int bitIndex = i * maxAlleles + allele;
                int n = bitIndex / 32;
                oneHot[n] = oneHot[n] | 1 << bitIndex % 32;
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return oneHot;
    }

    public static int[] guessPloidyAndMaxAllele(String snpLine) {
        String[] fields = snpLine.split("\t");
        if (fields.length < 10) {
            throw new IllegalArgumentException("SNP line does not contain FORMAT and sample fields.");
        }
        String[] formatFields = fields[8].split(":");
        int gtIndex = -1;
        for (int i = 0; i < formatFields.length; ++i) {
            if (!formatFields[i].equals("GT")) continue;
            gtIndex = i;
            break;
        }
        if (gtIndex == -1) {
            throw new IllegalArgumentException("GT field not found in FORMAT.");
        }
        int maxPloidy = 0;
        int maxAlleleIndex = 0;
        for (int i = 9; i < fields.length; ++i) {
            String gt;
            String[] parts = fields[i].split(":");
            if (gtIndex >= parts.length || (gt = parts[gtIndex]) == null) continue;
            String[] alleles = gt.split("[/|]");
            maxPloidy = Math.max(maxPloidy, alleles.length);
            for (String allele : alleles) {
                try {
                    int a = Integer.parseInt(allele);
                    if (a <= maxAlleleIndex) continue;
                    maxAlleleIndex = a;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }
        return new int[]{maxPloidy, maxAlleleIndex + 1};
    }

    public static int dotProd(int[] a, int[] b, int bitsPerGenotype) {
        int sum = 0;
        for (int idx = 0; idx < bitsPerGenotype; ++idx) {
            boolean isSetB;
            boolean isSetA = (a[idx / 32] & 1 << idx % 32) != 0;
            boolean bl = isSetB = (b[idx / 32] & 1 << idx % 32) != 0;
            if (!isSetA || !isSetB) continue;
            ++sum;
        }
        return sum;
    }
}

