/*
 * Decompiled with CFR 0.152.
 */
package com.gkano.bioinfo.javautils;

import com.beust.jcommander.Parameter;
import com.beust.jcommander.Parameters;
import com.gkano.bioinfo.tree.HierarchicalCluster;
import com.gkano.bioinfo.var.GeneralTools;
import com.gkano.bioinfo.var.Logger;
import java.io.FileInputStream;
import java.io.PrintStream;

@Parameters(commandDescription="DIST2TREE")
public class UtilDIST2TREE {
    @Parameter(names={"--help"}, help=true)
    private boolean help;
    @Parameter(names={"-v", "--verbose"})
    private boolean verbose = false;
    @Parameter(description="<positional input file>")
    private String positionalInputFile;
    @Parameter(names={"-i", "--input"}, description="Input file (overrides positional)")
    private String namedInputFile;
    @Parameter(names={"-o", "--output"}, description="Tree output file")
    private String outputFile;

    public static String getUtilName() {
        return "DIST2TREE";
    }

    public void go() {
        try (PrintStream ops = GeneralTools.getPrintStreamOrExit(this.outputFile, this);){
            Object[] data;
            String inputFileName;
            String string = inputFileName = this.namedInputFile != null ? this.namedInputFile : this.positionalInputFile;
            if (inputFileName == null) {
                Logger.error(this, "No input file provided.");
                return;
            }
            if ("-".equals(inputFileName)) {
                data = GeneralTools.readDistancesSamples(System.in);
            } else {
                try (FileInputStream fis = new FileInputStream(inputFileName);){
                    data = GeneralTools.readDistancesSamples(fis);
                }
            }
            HierarchicalCluster hc = new HierarchicalCluster(this.verbose);
            String treeString = (String)hc.hclusteringTree((String[])data[1], (double[][])data[0], null)[0];
            ops.println(treeString);
            ops.close();
        }
        catch (Exception e) {
            Logger.error(this, e.getMessage());
        }
    }
}

