/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

class SimpleComponentFeature
implements ComponentFeature {
    private FeatureHolder parent;
    private FeatureHolder projectedFeatures;
    private Location location;
    private String type;
    private String source;
    private Annotation annotation;
    private StrandedFeature.Strand strand;
    private Sequence componentSequence;
    private Location componentLocation;
    private int translation;

    public SimpleComponentFeature(FeatureHolder featureHolder, ComponentFeature.Template template) throws BioException {
        if (this.locationContent(template.location) != this.locationContent(template.componentLocation)) {
            throw new BioException("Component and container locations must contain an equal number of symbols.");
        }
        if (!template.location.isContiguous() || !template.componentLocation.isContiguous()) {
            throw new BioException("Can only include contiguous segments in an assembly [may change in future]");
        }
        this.parent = featureHolder;
        this.location = template.location;
        this.type = template.type;
        this.source = template.source;
        this.annotation = template.annotation;
        this.strand = template.strand;
        this.componentSequence = template.componentSequence;
        this.componentLocation = template.componentLocation;
        if (template.strand == StrandedFeature.NEGATIVE) {
            this.translation = template.location.getMax() - template.componentLocation.getMin() + 1;
            this.projectedFeatures = new ProjectedFeatureHolder(this.componentSequence, this, this.translation, true);
        } else if (template.strand == StrandedFeature.POSITIVE) {
            this.translation = template.location.getMin() - template.componentLocation.getMin();
            this.projectedFeatures = new ProjectedFeatureHolder(this.componentSequence, this, this.translation, false);
        } else {
            throw new BioException("Strand must be specified when creating a ComponentFeature");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public boolean containsFeature(Feature feature) {
        return this.getProjectedFeatures().containsFeature(feature);
    }

    public int countFeatures() {
        return this.componentSequence.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws BioException {
        throw new BioException("Can't create features in a ComponentFeature (yet?)");
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.getProjectedFeatures().filter(featureFilter, bl);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    public Sequence getComponentSequence() {
        return this.componentSequence;
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    protected FeatureHolder getProjectedFeatures() {
        return this.projectedFeatures;
    }

    public Sequence getSequence() {
        FeatureHolder featureHolder = this.parent;
        while (featureHolder instanceof Feature) {
            featureHolder = ((Feature)featureHolder).getParent();
        }
        return (Sequence)featureHolder;
    }

    public String getSource() {
        return this.source;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public SymbolList getSymbols() {
        SymbolList symbolList = this.componentLocation.symbols(this.componentSequence);
        if (this.strand == StrandedFeature.NEGATIVE) {
            try {
                symbolList = DNATools.reverseComplement(symbolList);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException);
            }
        }
        return symbolList;
    }

    public String getType() {
        return this.type;
    }

    private int locationContent(Location location) {
        if (location.isContiguous()) {
            return location.getMax() - location.getMin() + 1;
        }
        int n = 0;
        Iterator iterator = location.blockIterator();
        while (iterator.hasNext()) {
            Location location2 = (Location)iterator.next();
            n += location2.getMax() - location2.getMin() + 1;
        }
        return n;
    }

    public Feature.Template makeTemplate() {
        ComponentFeature.Template template = new ComponentFeature.Template();
        template.location = this.getLocation();
        template.type = this.getType();
        template.source = this.getSource();
        template.annotation = this.getAnnotation();
        template.strand = this.getStrand();
        template.componentSequence = this.getComponentSequence();
        template.componentLocation = this.getComponentLocation();
        return template;
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) {
        throw new UnsupportedOperationException("Can't remove features from a ComponentFeature.");
    }
}

