/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import java.io.PrintWriter;
import java.util.Map;
import org.biojava.bio.BioException;
import org.biojava.bio.program.gff.GFFDocumentHandler;
import org.biojava.bio.program.gff.GFFRecord;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.StrandedFeature;

public class GFFWriter
implements GFFDocumentHandler {
    private PrintWriter out;

    public GFFWriter(PrintWriter printWriter) {
        this.out = printWriter;
    }

    public void commentLine(String string) {
        this.out.println("#" + string);
    }

    public void endDocument() {
        this.out.flush();
    }

    public void invalidEnd(String string, NumberFormatException numberFormatException) throws BioException {
    }

    public void invalidFrame(String string, NumberFormatException numberFormatException) throws BioException {
    }

    public void invalidScore(String string, NumberFormatException numberFormatException) throws BioException {
    }

    public void invalidStart(String string, NumberFormatException numberFormatException) throws BioException {
    }

    public void invalidStrand(String string) throws BioException {
    }

    public void recordLine(GFFRecord gFFRecord) {
        String string;
        this.out.print(String.valueOf(gFFRecord.getSeqName()) + "\t" + gFFRecord.getSource() + "\t" + gFFRecord.getFeature() + "\t" + gFFRecord.getStart() + "\t" + gFFRecord.getEnd() + "\t");
        double d = gFFRecord.getScore();
        if (d == Double.NEGATIVE_INFINITY) {
            this.out.print(".\t");
        } else {
            this.out.print(String.valueOf(d) + "\t");
        }
        StrandedFeature.Strand strand = gFFRecord.getStrand();
        if (strand == StrandedFeature.POSITIVE) {
            this.out.print("+\t");
        } else if (strand == StrandedFeature.NEGATIVE) {
            this.out.print("-\t");
        } else {
            this.out.print(".\t");
        }
        int n = gFFRecord.getFrame();
        if (n == -1) {
            this.out.print(".");
        } else {
            this.out.print(String.valueOf(n));
        }
        Map map = gFFRecord.getGroupAttributes();
        String string2 = SimpleGFFRecord.stringifyAttributes(map);
        if (string2 != null && string2.length() > 0) {
            this.out.print("\t" + string2);
        }
        if ((string = gFFRecord.getComment()) != null && string.length() > 0) {
            if (string2 != null && string2.length() > 0) {
                this.out.print(" ");
            }
            this.out.print(string);
        }
        this.out.println("");
    }

    public void startDocument(String string) {
    }
}

