/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.gff;

import org.biojava.bio.program.gff.IgnoreRecordException;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.utils.ParserException;

public interface GFFErrorHandler {
    public static final GFFErrorHandler ABORT_PARSING = new AbortErrorHandler();
    public static final GFFErrorHandler SKIP_RECORD = new SkipRecordErrorHandler();

    public int invalidEnd(String var1) throws ParserException, IgnoreRecordException;

    public int invalidFrame(String var1) throws ParserException, IgnoreRecordException;

    public double invalidScore(String var1) throws ParserException, IgnoreRecordException;

    public int invalidStart(String var1) throws ParserException, IgnoreRecordException;

    public StrandedFeature.Strand invalidStrand(String var1) throws ParserException, IgnoreRecordException;

    public static class AbortErrorHandler
    implements GFFErrorHandler {
        public int invalidEnd(String string) throws ParserException {
            throw new ParserException("Invalid end token");
        }

        public int invalidFrame(String string) throws ParserException {
            throw new ParserException("Invalid frame token");
        }

        public double invalidScore(String string) throws ParserException {
            throw new ParserException("Invalid score token");
        }

        public int invalidStart(String string) throws ParserException {
            throw new ParserException("Invalid start token");
        }

        public StrandedFeature.Strand invalidStrand(String string) throws ParserException {
            throw new ParserException("Invalid strand token");
        }
    }

    public static class SkipRecordErrorHandler
    implements GFFErrorHandler {
        public int invalidEnd(String string) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        public int invalidFrame(String string) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        public double invalidScore(String string) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        public int invalidStart(String string) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }

        public StrandedFeature.Strand invalidStrand(String string) throws IgnoreRecordException {
            throw new IgnoreRecordException();
        }
    }
}

