/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import org.biojava.bio.Annotatable;
import org.biojava.bio.Annotation;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;

public abstract class AbstractSymbol
implements Symbol {
    protected transient ChangeSupport changeSupport = null;
    protected transient Annotatable.AnnotationForwarder annotationForwarder = null;

    public void addChangeListener(ChangeListener changeListener) {
        this.generateChangeSupport(null);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.generateChangeSupport(changeType);
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    protected void generateChangeSupport(ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        if ((changeType == null || changeType == Annotation.PROPERTY) && this.annotationForwarder == null) {
            this.annotationForwarder = new Annotatable.AnnotationForwarder(this, this.changeSupport);
            this.getAnnotation().addChangeListener(this.annotationForwarder, Annotation.PROPERTY);
        }
    }

    public abstract Annotation getAnnotation();

    public abstract Alphabet getMatches();

    public abstract String getName();

    public abstract char getToken();

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public String toString() {
        return String.valueOf(this.getClass().getName()) + ": " + this.getName();
    }
}

