/*
 * Decompiled with CFR 0.152.
 */
package eponine;

import eponine.model.EponineXML;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import org.apache.xerces.parsers.DOMParser;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.program.gff.GFFWriter;
import org.biojava.bio.program.gff.SimpleGFFRecord;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SequenceIterator;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.seq.io.SeqIOTools;
import org.biojava.bio.symbol.AtomicSymbol;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;

public class WMScan {
    public static final String VERSION = "0.1";

    public static void main(String[] stringArray) throws Exception {
        if (stringArray.length != 3) {
            System.err.println("usage: java ScanApp sequence.fasta model.xml threshold");
            return;
        }
        String string = stringArray[0];
        String string2 = stringArray[1];
        double d = Double.parseDouble(stringArray[2]);
        EponineXML eponineXML = new EponineXML();
        InputSource inputSource = new InputSource(new FileReader(string2));
        DOMParser dOMParser = new DOMParser();
        dOMParser.parse(inputSource);
        Element element = dOMParser.getDocument().getDocumentElement();
        WeightMatrix weightMatrix = eponineXML.readWeightMatrix(element);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
        SequenceIterator sequenceIterator = SeqIOTools.readFastaDNA(bufferedReader);
        Sequence sequence = sequenceIterator.nextSequence();
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter(System.out));
        GFFWriter gFFWriter = new GFFWriter(printWriter);
        gFFWriter.startDocument("");
        gFFWriter.commentLine(" Output from Eponine WMApp 0.1");
        gFFWriter.commentLine(" Model: " + string2);
        gFFWriter.commentLine(" Threshold: " + d);
        WMScan.wmScan(gFFWriter, weightMatrix, sequence, d, false);
        WMScan.wmScan(gFFWriter, weightMatrix, sequence, d, true);
        printWriter.flush();
    }

    public static void wmScan(GFFWriter gFFWriter, WeightMatrix weightMatrix, Sequence sequence, double d, boolean bl) throws Exception {
        SymbolList symbolList = bl ? DNATools.reverseComplement(sequence) : sequence;
        int n = -1000;
        int n2 = -1000;
        double d2 = Double.NEGATIVE_INFINITY;
        int n3 = 1;
        int n4 = 1;
        while (n4 < symbolList.length()) {
            double d3 = WMScan.scoreWM(weightMatrix, sequence, n4);
            if (d3 > d) {
                d2 = Math.max(d2, d3);
                n = n4;
                if (n2 < 0) {
                    n2 = n4;
                }
            } else if (n > 0 && n4 - n > n3) {
                SimpleGFFRecord simpleGFFRecord = new SimpleGFFRecord();
                simpleGFFRecord.setSource("WeightMatrix");
                simpleGFFRecord.setFeature("Hit");
                simpleGFFRecord.setScore(d2);
                simpleGFFRecord.setSeqName(sequence.getName());
                if (bl) {
                    simpleGFFRecord.setEnd(sequence.length() - n2 + 2);
                    simpleGFFRecord.setStart(sequence.length() - n + 2);
                    simpleGFFRecord.setStrand(StrandedFeature.NEGATIVE);
                } else {
                    simpleGFFRecord.setStart(n2);
                    simpleGFFRecord.setEnd(n);
                    simpleGFFRecord.setStrand(StrandedFeature.POSITIVE);
                }
                simpleGFFRecord.setFrame(-1);
                gFFWriter.recordLine(simpleGFFRecord);
                n = -1000;
                n2 = -1000;
                d2 = Double.NEGATIVE_INFINITY;
            }
            ++n4;
        }
    }

    public static double scoreWM(WeightMatrix weightMatrix, Sequence sequence, int n) throws Exception {
        double d = 0.0;
        int n2 = sequence.length();
        int n3 = 0;
        while (n3 < weightMatrix.columns()) {
            int n4 = n + n3;
            if (n4 < 1 || n4 > n2) {
                return Double.NEGATIVE_INFINITY;
            }
            Symbol symbol = sequence.symbolAt(n + n3);
            if (!(symbol instanceof AtomicSymbol)) {
                return Double.NEGATIVE_INFINITY;
            }
            d += weightMatrix.getColumn(n3).getWeight(symbol);
            ++n3;
        }
        return d;
    }
}

