## ----message=FALSE, warning=FALSE, include=FALSE------------------------------
knitr::opts_chunk$set(echo = TRUE, message = FALSE, warning = FALSE, dpi = 72)
suppressWarnings(library(ggplot2))
suppressMessages(library(scider))
suppressMessages(library(SpatialExperiment))

## ----eval=FALSE---------------------------------------------------------------
# if (!require("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# 
# BiocManager::install("scider")

## ----eval=FALSE---------------------------------------------------------------
# devtools::install_github("ChenLaboratory/scider")

## -----------------------------------------------------------------------------
library(scider)
library(SpatialExperiment)

## -----------------------------------------------------------------------------
data("xenium_bc_spe")

## -----------------------------------------------------------------------------
spe

## -----------------------------------------------------------------------------
table(colData(spe)$cell_type)

## ----fig.width=5, fig.height=4------------------------------------------------
plotSpatial(spe, color = cell_type, alpha = 0.8)

## -----------------------------------------------------------------------------
coi <- unique(colData(spe)$cell_type)
coi

## -----------------------------------------------------------------------------
spe <- gridDensity(spe, coi = coi)

names(metadata(spe))

## -----------------------------------------------------------------------------
metadata(spe)$grid_density

## ----fig.width=5, fig.height=4------------------------------------------------
plotDensity(spe, coi = coi[1])

## -----------------------------------------------------------------------------
spe <- findROI(spe, coi = coi)

metadata(spe)$roi

## ----fig.width=5, fig.height=5------------------------------------------------
plotROI(spe)

## ----eval=FALSE---------------------------------------------------------------
# selectRegion(metadata(spe)$grid_density, x.col = "x_grid", y.col = "y_grid")

## ----eval=FALSE---------------------------------------------------------------
# sel_region

## ----eval=FALSE---------------------------------------------------------------
# spe1 <- postSelRegion(spe, sel_region = sel_region)
# 
# metadata(spe1)$roi

## ----eval=FALSE---------------------------------------------------------------
# plotROI(spe1)

## -----------------------------------------------------------------------------
model_result <- corDensity(spe)

## -----------------------------------------------------------------------------
model_result

## ----fig.width=8, fig.height=6------------------------------------------------
plotDensCor(spe, celltype1 = "Breast cancer", celltype2 = "Fibroblasts")

## ----fig.width=7, fig.height=4------------------------------------------------
plotCorHeatmap(model_result)

## ----fig.width=5, fig.height=4------------------------------------------------
model_result2 <- corDensity(spe, by.roi = FALSE)

plotCorHeatmap(model_result2)

## -----------------------------------------------------------------------------
spe <- getContour(spe, coi = "Breast cancer")

## ----fig.width=5, fig.height=4------------------------------------------------
plotContour(spe, coi = "Breast cancer")

## -----------------------------------------------------------------------------
spe <- allocateCells(spe)

## ----fig.width=6, fig.height=4------------------------------------------------
plotSpatial(spe, color = breast_cancer_contour, alpha = 0.5)

## ----fig.width=6, fig.height=4------------------------------------------------
plotCellCompo(spe, coi = "Breast cancer")

## ----fig.width=7, fig.height=5------------------------------------------------
plotCellCompo(spe, coi = "Breast cancer", by.roi = TRUE)

## -----------------------------------------------------------------------------
sessionInfo()

