/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.alignment.errorcheck;

import edu.msu.cme.rdp.alignment.AlignmentMode;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAligner;
import edu.msu.cme.rdp.alignment.pairwise.PairwiseAlignment;
import edu.msu.cme.rdp.alignment.pairwise.ScoringMatrix;
import edu.msu.cme.rdp.readseq.QSequence;
import edu.msu.cme.rdp.readseq.readers.QSeqReader;
import edu.msu.cme.rdp.readseq.readers.Sequence;
import edu.msu.cme.rdp.readseq.readers.SequenceReader;
import edu.msu.cme.rdp.readseq.utils.IUBUtilities;
import edu.msu.cme.rdp.readseq.utils.SeqUtils;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.PosixParser;

public class CompareErrorType {
    private static final char gapChar = '-';
    private PrintStream misMatch_writer = null;
    private PrintStream indel_writer = null;
    private PrintStream qualOut = null;

    public CompareErrorType(File mismatch_out, File indel_out) throws IOException {
        this(mismatch_out, indel_out, null);
    }

    public CompareErrorType(File mismatch_out, File indel_out, File qualOutFile) throws IOException {
        this.misMatch_writer = new PrintStream(mismatch_out);
        this.indel_writer = new PrintStream(indel_out);
        if (qualOutFile != null) {
            this.qualOut = new PrintStream(qualOutFile);
        }
    }

    public void processSequence(Sequence querySeq, String alignedQuery, String refSeqId, String refSeq, int refStart, boolean reversed) throws IOException {
        int[][] positionMapping = this.mapSequences(refSeq, refStart, alignedQuery);
        String[] qualInfo = null;
        if (this.qualOut != null) {
            Object[] tmp = this.mapQualScores((QSequence)querySeq, alignedQuery, reversed);
            qualInfo = (String[])tmp[0];
            float avgQScore = ((Float)tmp[1]).floatValue();
            float avgEQScore = ((Float)tmp[2]).floatValue();
            this.qualOut.println(querySeq.getSeqName() + "\t" + avgQScore + "\t" + avgEQScore);
        }
        this.compare(querySeq.getSeqName(), refSeqId, refSeq, alignedQuery, qualInfo, positionMapping[0], positionMapping[1]);
    }

    public void close() throws IOException {
        this.misMatch_writer.close();
        this.indel_writer.close();
        if (this.qualOut != null) {
            this.qualOut.close();
        }
    }

    private int[][] mapSequences(String alignedRefSeq, int refStart, String alignedQuerySeq) {
        int[][] ret = new int[2][alignedRefSeq.length()];
        int refLoc = 0;
        int queryLoc = 0;
        char[] ref = alignedRefSeq.toCharArray();
        char[] query = alignedQuerySeq.toCharArray();
        for (int index = 0; index < ref.length; ++index) {
            if (ref[index] != '-') {
                ++refLoc;
            }
            if (query[index] != '-') {
                // empty if block
            }
            ret[0][index] = ++queryLoc;
            ret[1][index] = refLoc + refStart;
        }
        return ret;
    }

    private Object[] mapQualScores(QSequence seq, String alignedSeqString, boolean reversed) throws IOException {
        String[] ret = new String[alignedSeqString.length()];
        String dealignedSeqString = SeqUtils.getUnalignedSeqString((String)alignedSeqString);
        byte[] qualScores = seq.getQuality();
        if (qualScores.length != dealignedSeqString.length()) {
            throw new IOException(seq.getSeqName() + "'s quality string [" + qualScores.length + "] and seq string lengths [" + dealignedSeqString.length() + "] do not match");
        }
        if (reversed) {
            int start = 0;
            for (int end = qualScores.length - 1; start < end; ++start, --end) {
                byte tmp = qualScores[start];
                qualScores[start] = qualScores[end];
                qualScores[end] = tmp;
            }
        }
        float avgEQual = 0.0f;
        int numQualScores = 0;
        int scoreIndex = 0;
        for (int index = 0; index < dealignedSeqString.length(); ++index) {
            while (alignedSeqString.charAt(scoreIndex) == '-') {
                ret[scoreIndex++] = "-1";
            }
            ret[scoreIndex++] = qualScores[index] + "";
            ++numQualScores;
            avgEQual = (float)((double)avgEQual + Math.pow(10.0, -1.0 * (Double.valueOf(qualScores[index]) / 10.0)));
        }
        float avgQual = -10.0f * (float)Math.log10(avgEQual /= (float)numQualScores);
        return new Object[]{ret, Float.valueOf(avgQual), Float.valueOf(avgEQual)};
    }

    private String compare(String querySeqName, String refSeqName, String r, String q, String[] qualInfo, int[] queryPosMapping, int[] refPosMapping) throws IOException {
        StringBuilder buf = new StringBuilder();
        char badChar = '-';
        int i = 0;
        while (i < r.length()) {
            char rc = r.charAt(i);
            char qc = q.charAt(i);
            if (rc != '-' && qc != '-') {
                if (rc != qc) {
                    this.misMatch_writer.println(querySeqName + "\t" + refSeqName + "\t" + (i + 1) + "\t" + rc + "\t" + qc + "\t" + queryPosMapping[i] + "\t" + refPosMapping[i] + "\t" + (qualInfo == null ? "null" : qualInfo[i]));
                }
                ++i;
                continue;
            }
            badChar = rc == '-' ? (char)qc : (char)rc;
            CountResult refCount = CompareErrorType.count(r, i, badChar);
            CountResult queryCount = CompareErrorType.count(q, i, badChar);
            this.indel_writer.println(querySeqName + "\t" + refSeqName + "\t" + (i + 1) + "\t" + (refCount.forwardCount + refCount.backCount) + "\t" + (queryCount.forwardCount + queryCount.backCount) + "\t" + badChar + "\t" + queryPosMapping[i] + "\t" + refPosMapping[i] + "\t" + (qualInfo == null ? "null" : qualInfo[i]));
            ++i;
        }
        return buf.toString();
    }

    private static CountResult count(String r, int i, char badChar) {
        int backCount = 0;
        for (int j = i; j >= 0; --j) {
            if (r.charAt(j) == '-') continue;
            if (r.charAt(j) != badChar) break;
            ++backCount;
        }
        int forwardCount = 0;
        for (int j = i + 1; j < r.length(); ++j) {
            if (r.charAt(j) == '-') continue;
            if (r.charAt(j) != badChar) break;
            ++forwardCount;
        }
        CountResult result = new CountResult();
        result.backCount = backCount;
        result.forwardCount = forwardCount;
        return result;
    }

    public static void main(String[] args) throws IOException {
        PrintStream alignOutStream;
        CompareErrorType errorProcessor;
        Sequence seq;
        Object queryReader;
        List refSeqList;
        Options options = new Options();
        options.addOption("s", "stem", true, "Output stem (default <query_nucl.fasta>)");
        HashMap<String, PAObject> matchMap = new HashMap<String, PAObject>();
        try {
            CommandLine line = new PosixParser().parse(options, args);
            args = line.getArgs();
            if (args.length != 2 && args.length != 3) {
                throw new Exception("Unexpected number of arguments");
            }
            File refFile = new File(args[0]);
            File queryFile = new File(args[1]);
            String stem = line.hasOption("stem") ? line.getOptionValue("stem") : queryFile.getName();
            File alignOutFile = new File(stem + "_alignments.txt");
            File mismatchOutFile = new File(stem + "_mismatches.txt");
            File indelOutFile = new File(stem + "_indels.txt");
            File qualOutFile = null;
            refSeqList = SequenceReader.readFully((File)refFile);
            queryReader = args.length == 3 ? new QSeqReader(queryFile, new File(args[2])) : new SequenceReader(queryFile);
            seq = queryReader.readNextSequence();
            if (seq instanceof QSequence) {
                qualOutFile = new File(stem + "_qual.txt");
            }
            errorProcessor = new CompareErrorType(mismatchOutFile, indelOutFile, qualOutFile);
            alignOutStream = new PrintStream(alignOutFile);
            System.err.println("Starting CompareErrorType");
            System.err.println("*  Time:              " + new Date());
            System.err.println("*  Reference File:    " + refFile);
            System.err.println("*  Query File:        " + queryFile);
            if (args.length == 3) {
                System.err.println("*  Qual File:         " + args[2]);
            }
            System.err.println("*  Query format:      " + queryReader.getFormat());
            System.err.println("*  Alignment Output:  " + alignOutFile);
            System.err.println("*  Mismatches Output: " + mismatchOutFile);
            System.err.println("*  Alignment Output:  " + indelOutFile);
            if (qualOutFile != null) {
                System.err.println("*  Quality Output:    " + qualOutFile);
            }
        }
        catch (Exception e) {
            new HelpFormatter().printHelp("CompareErrorType [options] <ref_nucl> (<query_nucl> | <query_nucl.fasta> <query_nucl.qual>)", options);
            System.err.println("ERROR: " + e.getMessage());
            throw new RuntimeException(e);
        }
        ScoringMatrix scoringMatrix = new ScoringMatrix(ScoringMatrix.class.getResourceAsStream("/data/simple_scoringmatrix.txt"), -1, -1);
        do {
            try {
                PairwiseAlignment bestResult = null;
                Sequence bestSeq = null;
                boolean bestReversed = false;
                String querySeqStr = seq.getSeqString().toLowerCase();
                String reversedQuery = IUBUtilities.reverseComplement((String)querySeqStr);
                PAObject bestMatch = null;
                if (matchMap.containsKey(seq.getSeqString())) {
                    bestMatch = (PAObject)matchMap.get(seq.getSeqString());
                } else {
                    for (Sequence refSeq : refSeqList) {
                        PairwiseAlignment currBest;
                        String refSeqStr = refSeq.getSeqString().toLowerCase();
                        PairwiseAlignment result = PairwiseAligner.align(refSeqStr, querySeqStr, scoringMatrix, AlignmentMode.global);
                        PairwiseAlignment reversedResult = PairwiseAligner.align(refSeqStr, IUBUtilities.reverseComplement((String)querySeqStr), scoringMatrix, AlignmentMode.global);
                        PairwiseAlignment pairwiseAlignment = currBest = result.getScore() > reversedResult.getScore() ? result : reversedResult;
                        if (bestResult == null || currBest.getScore() > bestResult.getScore()) {
                            bestResult = currBest;
                            bestSeq = refSeq;
                            bestReversed = currBest == reversedResult;
                        }
                        bestMatch = new PAObject(bestResult, bestReversed, bestSeq);
                        matchMap.put(seq.getSeqString(), bestMatch);
                    }
                }
                int refStart = bestMatch.getPA().getStarti();
                int refEnd = bestMatch.getPA().getEndi();
                bestSeq = bestMatch.getRefSeq();
                bestReversed = bestMatch.getReversed();
                bestResult = bestMatch.getPA();
                alignOutStream.println(">\t" + seq.getSeqName() + "\t" + bestSeq.getSeqName() + "\t" + seq.getSeqString().length() + "\t" + refStart + "\t" + refEnd + "\t" + bestResult.getScore() + "\t" + (bestReversed ? "\treversed" : ""));
                alignOutStream.println(bestResult.getAlignedSeqj() + "\n");
                alignOutStream.println(bestResult.getAlignedSeqi() + "\n");
                errorProcessor.processSequence(seq, bestResult.getAlignedSeqj(), bestSeq.getSeqName(), bestResult.getAlignedSeqi(), refStart, bestReversed);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed while processing seq " + seq.getSeqName(), e);
            }
        } while ((seq = queryReader.readNextSequence()) != null);
        queryReader.close();
        alignOutStream.close();
        errorProcessor.close();
    }

    public static class PAObject {
        PairwiseAlignment PA;
        boolean reversed;
        Sequence refSeq;

        public PAObject(PairwiseAlignment pa, boolean reverse, Sequence seq) {
            this.PA = pa;
            this.reversed = reverse;
            this.refSeq = seq;
        }

        public PairwiseAlignment getPA() {
            return this.PA;
        }

        public boolean getReversed() {
            return this.reversed;
        }

        public Sequence getRefSeq() {
            return this.refSeq;
        }
    }

    public static class CountResult {
        int backCount;
        int forwardCount;
    }
}

