/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui.sequence;

import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.io.Serializable;
import java.util.List;
import org.biojava.bio.gui.sequence.SequenceRenderContext;
import org.biojava.bio.gui.sequence.SequenceRenderer;
import org.biojava.bio.gui.sequence.SequenceViewerEvent;
import org.biojava.bio.symbol.RangeLocation;
import org.biojava.utils.AbstractChangeable;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeForwarder;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;

public class SequenceRendererWrapper
extends AbstractChangeable
implements SequenceRenderer,
Serializable {
    public static ChangeType RENDERER = new ChangeType("The renderer used to render the filtered features has changed", "org.biojava.bio.gui.sequence.FilteringRenderer", "RENDERER", SequenceRenderContext.LAYOUT);
    private SequenceRenderer renderer;
    private transient ChangeForwarder rendForwarder;

    public SequenceRendererWrapper() {
    }

    public SequenceRendererWrapper(SequenceRenderer sequenceRenderer) {
        this.renderer = sequenceRenderer;
    }

    protected ChangeSupport getChangeSupport(ChangeType changeType) {
        ChangeSupport changeSupport = super.getChangeSupport(changeType);
        if (this.rendForwarder == null) {
            this.rendForwarder = new SequenceRenderer.RendererForwarder(this, changeSupport);
            if (this.renderer != null && this.renderer instanceof Changeable) {
                Changeable changeable = (Changeable)((Object)this.renderer);
                changeable.addChangeListener(this.rendForwarder, SequenceRenderContext.REPAINT);
            }
        }
        return changeSupport;
    }

    public double getDepth(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.getRenderer().getDepth(sequenceRenderContext, rangeLocation);
    }

    public double getMinimumLeader(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.getRenderer().getMinimumLeader(sequenceRenderContext, rangeLocation);
    }

    public double getMinimumTrailer(SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        return this.getRenderer().getMinimumTrailer(sequenceRenderContext, rangeLocation);
    }

    public SequenceRenderer getRenderer() {
        return this.renderer;
    }

    public void paint(Graphics2D graphics2D, SequenceRenderContext sequenceRenderContext, RangeLocation rangeLocation) {
        this.getRenderer().paint(graphics2D, sequenceRenderContext, rangeLocation);
    }

    public SequenceViewerEvent processMouseEvent(SequenceRenderContext sequenceRenderContext, MouseEvent mouseEvent, List list, RangeLocation rangeLocation) {
        list.add(this);
        return this.getRenderer().processMouseEvent(sequenceRenderContext, mouseEvent, list, rangeLocation);
    }

    public void setRenderer(SequenceRenderer sequenceRenderer) throws ChangeVetoException {
        if (this.hasListeners()) {
            ChangeSupport changeSupport;
            ChangeEvent changeEvent = new ChangeEvent(this, RENDERER, sequenceRenderer, this.renderer);
            ChangeSupport changeSupport2 = changeSupport = this.getChangeSupport(RENDERER);
            synchronized (changeSupport2) {
                Changeable changeable;
                changeSupport.firePreChangeEvent(changeEvent);
                if (sequenceRenderer != null && sequenceRenderer instanceof Changeable) {
                    changeable = (Changeable)((Object)this.renderer);
                    changeable.removeChangeListener(this.rendForwarder);
                }
                this.renderer = sequenceRenderer;
                if (sequenceRenderer instanceof Changeable) {
                    changeable = (Changeable)((Object)sequenceRenderer);
                    changeable.removeChangeListener(this.rendForwarder);
                }
                changeSupport.firePostChangeEvent(changeEvent);
            }
        } else {
            this.renderer = sequenceRenderer;
        }
    }
}

