/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.readers;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.apache.xerces.framework.XMLErrorReporter;
import org.apache.xerces.readers.MIME2Java;
import org.apache.xerces.readers.XMLDeclRecognizer;
import org.apache.xerces.readers.XMLEntityHandler;
import org.apache.xerces.readers.XMLEntityReader;
import org.apache.xerces.readers.XMLEntityReaderFactory;
import org.apache.xerces.utils.ChunkyByteArray;
import org.apache.xerces.utils.QName;
import org.apache.xerces.utils.StringPool;

final class UTF8Recognizer
extends XMLDeclRecognizer {
    private byte[] fUTF8BOM = new byte[]{-17, -69, -65};

    UTF8Recognizer() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public XMLEntityHandler.EntityReader recognize(XMLEntityReaderFactory xMLEntityReaderFactory, XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, StringPool stringPool, ChunkyByteArray chunkyByteArray, boolean bl2, boolean bl3) throws Exception {
        XMLDeclReader xMLDeclReader;
        int n;
        byte by;
        byte by2;
        XMLEntityHandler.EntityReader entityReader = null;
        boolean bl4 = false;
        byte by3 = chunkyByteArray.byteAt(0);
        if (by3 == this.fUTF8BOM[0] && (by2 = chunkyByteArray.byteAt(1)) == this.fUTF8BOM[1] && (by = chunkyByteArray.byteAt(2)) == this.fUTF8BOM[2]) {
            bl4 = true;
        }
        if (bl4) {
            chunkyByteArray.read(this.fUTF8BOM, 0, 3);
        }
        by2 = chunkyByteArray.byteAt(0);
        by = 0;
        if (by2 != 60) return entityReader;
        byte by4 = chunkyByteArray.byteAt(1);
        if (by4 != 63) return entityReader;
        if (chunkyByteArray.byteAt(2) != 120) return entityReader;
        if (chunkyByteArray.byteAt(3) != 109) return entityReader;
        if (chunkyByteArray.byteAt(4) != 108) return entityReader;
        byte by5 = chunkyByteArray.byteAt(5);
        if (by5 != 32 && by5 != 9 && by5 != 10) {
            if (by5 != 13) return entityReader;
        }
        if ((n = this.prescanXMLDeclOrTextDecl(xMLDeclReader = new XMLDeclReader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool), bl2)) != -1) {
            String string = stringPool.orphanString(n);
            String string2 = string.toUpperCase();
            if ("ISO-10646-UCS-2".equals(string2)) {
                throw new UnsupportedEncodingException(string);
            }
            if ("ISO-10646-UCS-4".equals(string2)) {
                throw new UnsupportedEncodingException(string);
            }
            if ("UTF-16".equals(string2)) {
                throw new UnsupportedEncodingException(string);
            }
            String string3 = MIME2Java.convert(string2);
            if (null == string3) {
                if (!bl3) throw new UnsupportedEncodingException(string);
                string3 = string;
            }
            try {
                chunkyByteArray.rewind();
                if ("UTF-8".equalsIgnoreCase(string3)) return xMLEntityReaderFactory.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
                if (!"UTF8".equalsIgnoreCase(string3)) return xMLEntityReaderFactory.createCharReader(xMLEntityHandler, xMLErrorReporter, bl, new InputStreamReader((InputStream)chunkyByteArray, string3), stringPool);
                return xMLEntityReaderFactory.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new UnsupportedEncodingException(string);
            }
            catch (Exception exception) {
                if (by != 1) return entityReader;
                exception.printStackTrace();
                return entityReader;
            }
        } else {
            chunkyByteArray.rewind();
            return xMLEntityReaderFactory.createUTF8Reader(xMLEntityHandler, xMLErrorReporter, bl, chunkyByteArray, stringPool);
        }
    }

    final class XMLDeclReader
    extends XMLEntityReader {
        private StringPool fStringPool = null;
        private ChunkyByteArray fData = null;

        XMLDeclReader(XMLEntityHandler xMLEntityHandler, XMLErrorReporter xMLErrorReporter, boolean bl, ChunkyByteArray chunkyByteArray, StringPool stringPool) {
            super(xMLEntityHandler, xMLErrorReporter, bl);
            this.fStringPool = stringPool;
            this.fData = chunkyByteArray;
        }

        public boolean lookingAtChar(char c, boolean bl) throws IOException {
            if (this.fData.byteAt(this.fCurrentOffset) != c) {
                return false;
            }
            if (bl) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public boolean lookingAtSpace(boolean bl) throws IOException {
            int n = this.fData.byteAt(this.fCurrentOffset) & 0xFF;
            if (n != 32 && n != 9 && n != 10 && n != 13) {
                return false;
            }
            if (bl) {
                ++this.fCurrentOffset;
            }
            return true;
        }

        public void skipPastSpaces() throws IOException {
            int n;
            while ((n = this.fData.byteAt(this.fCurrentOffset) & 0xFF) == 32 || n == 9 || n == 10 || n == 13) {
                ++this.fCurrentOffset;
            }
            return;
        }

        public boolean skippedString(char[] cArray) throws IOException {
            int n = this.fCurrentOffset;
            int n2 = 0;
            while (n2 < cArray.length) {
                if (this.fData.byteAt(n) != cArray[n2]) {
                    return false;
                }
                ++n;
                ++n2;
            }
            this.fCurrentOffset = n;
            return true;
        }

        public int scanStringLiteral() throws Exception {
            int n;
            int n2;
            boolean bl = this.lookingAtChar('\'', true);
            if (!bl && !this.lookingAtChar('\"', true)) {
                return -1;
            }
            int n3 = this.fCurrentOffset;
            int n4 = n2 = bl ? 39 : 34;
            while ((n = this.fData.byteAt(this.fCurrentOffset)) != n2) {
                if (n == -1) {
                    return -1;
                }
                ++this.fCurrentOffset;
            }
            n = this.fCurrentOffset - n3;
            StringBuffer stringBuffer = new StringBuffer(n);
            int n5 = 0;
            while (n5 < n) {
                stringBuffer.append((char)this.fData.byteAt(n3 + n5));
                ++n5;
            }
            int n6 = this.fStringPool.addString(stringBuffer.toString());
            ++this.fCurrentOffset;
            return n6;
        }

        public void append(XMLEntityHandler.CharBuffer charBuffer, int n, int n2) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public int addString(int n, int n2) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public int addSymbol(int n, int n2) {
            throw new RuntimeException("RDR002 cannot happen");
        }

        public void skipToChar(char c) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void skipPastName(char c) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void skipPastNmtoken(char c) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public boolean lookingAtValidChar(boolean bl) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanInvalidChar() throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanCharRef(boolean bl) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanAttValue(char c, boolean bl) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanEntityValue(int n, boolean bl) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public boolean scanExpectedName(char c, StringPool.CharArrayRange charArrayRange) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public void scanQName(char c, QName qName) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanName(char c) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }

        public int scanContent(QName qName) throws IOException {
            throw new IOException("RDR002 cannot happen");
        }
    }
}

