/*
 * Decompiled with CFR 0.152.
 */
package edu.rit.util;

public class Packing {
    private Packing() {
    }

    public static int packIntLittleEndian(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 0;
        for (int i = 0; i <= 3; ++i) {
            n2 |= (byArray[n + i] & 0xFF) << i * 8;
        }
        return n2;
    }

    public static int packIntBigEndian(byte[] byArray, int n) {
        if (n + 4 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        int n2 = 0;
        for (int i = 0; i <= 3; ++i) {
            n2 |= (byArray[n + i] & 0xFF) << (3 - i) * 8;
        }
        return n2;
    }

    public static void packIntLittleEndian(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        if (n + 4 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = Packing.packIntLittleEndian(byArray, n + 4 * i);
        }
    }

    public static void packIntBigEndian(byte[] byArray, int n, int[] nArray, int n2, int n3) {
        if (n + 4 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + n3 > nArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            nArray[n2 + i] = Packing.packIntBigEndian(byArray, n + 4 * i);
        }
    }

    public static long packLongLittleEndian(byte[] byArray, int n) {
        if (n + 8 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = 0; i <= 7; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << i * 8;
        }
        return l;
    }

    public static long packLongBigEndian(byte[] byArray, int n) {
        if (n + 8 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        long l = 0L;
        for (int i = 0; i <= 7; ++i) {
            l |= ((long)byArray[n + i] & 0xFFL) << (7 - i) * 8;
        }
        return l;
    }

    public static void packLongLittleEndian(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        if (n + 8 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            lArray[n2 + i] = Packing.packLongLittleEndian(byArray, n + 8 * i);
        }
    }

    public static void packLongBigEndian(byte[] byArray, int n, long[] lArray, int n2, int n3) {
        if (n + 8 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + n3 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            lArray[n2 + i] = Packing.packLongBigEndian(byArray, n + 8 * i);
        }
    }

    public static void unpackIntLittleEndian(int n, byte[] byArray, int n2) {
        if (n2 + 4 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 3; ++i) {
            byArray[n2 + i] = (byte)(n >> i * 8);
        }
    }

    public static void unpackIntBigEndian(int n, byte[] byArray, int n2) {
        if (n2 + 4 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 3; ++i) {
            byArray[n2 + i] = (byte)(n >> (3 - i) * 8);
        }
    }

    public static void unpackIntLittleEndian(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > nArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + 4 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            Packing.unpackIntLittleEndian(nArray[n + i], byArray, n2 + 4 * i);
        }
    }

    public static void unpackIntBigEndian(int[] nArray, int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > nArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + 4 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            Packing.unpackIntBigEndian(nArray[n + i], byArray, n2 + 4 * i);
        }
    }

    public static void unpackLongLittleEndian(long l, byte[] byArray, int n) {
        if (n + 8 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 7; ++i) {
            byArray[n + i] = (byte)(l >> i * 8);
        }
    }

    public static void unpackLongBigEndian(long l, byte[] byArray, int n) {
        if (n + 8 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i <= 7; ++i) {
            byArray[n + i] = (byte)(l >> (7 - i) * 8);
        }
    }

    public static void unpackLongLittleEndian(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + 8 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            Packing.unpackLongLittleEndian(lArray[n + i], byArray, n2 + 8 * i);
        }
    }

    public static void unpackLongBigEndian(long[] lArray, int n, byte[] byArray, int n2, int n3) {
        if (n + n3 > lArray.length) {
            throw new IndexOutOfBoundsException();
        }
        if (n2 + 8 * n3 > byArray.length) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < n3; ++i) {
            Packing.unpackLongBigEndian(lArray[n + i], byArray, n2 + 8 * i);
        }
    }
}

