/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.structure;

import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.cram.common.Version;
import java.util.Arrays;

public final class CramHeader {
    public static final byte[] MAGIC = "CRAM".getBytes();
    private Version version;
    private final byte[] id = new byte[20];
    private SAMFileHeader samFileHeader;

    private CramHeader() {
        Arrays.fill(this.id, (byte)0);
    }

    public CramHeader(Version version, String id, SAMFileHeader samFileHeader) {
        Arrays.fill(this.id, (byte)0);
        this.version = version;
        if (id != null) {
            System.arraycopy(id.getBytes(), 0, this.id, 0, Math.min(id.length(), this.id.length));
        }
        this.samFileHeader = samFileHeader;
    }

    public void setID(String stringID) {
        System.arraycopy(stringID.getBytes(), 0, this.id, 0, Math.min(this.id.length, stringID.length()));
    }

    public CramHeader clone() {
        CramHeader clone = new CramHeader();
        clone.version = this.version;
        System.arraycopy(this.id, 0, clone.id, 0, this.id.length);
        clone.samFileHeader = this.getSamFileHeader().clone();
        return clone;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CramHeader)) {
            return false;
        }
        CramHeader header = (CramHeader)obj;
        if (this.getVersion().major != header.getVersion().major) {
            return false;
        }
        if (this.getVersion().minor != header.getVersion().minor) {
            return false;
        }
        return Arrays.equals(this.id, header.id) && this.getSamFileHeader().equals(header.getSamFileHeader());
    }

    public SAMFileHeader getSamFileHeader() {
        return this.samFileHeader;
    }

    public byte[] getId() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }
}

