/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.BAMFileSpan;
import htsjdk.samtools.BAMIndex;
import htsjdk.samtools.BrowseableBAMIndex;
import htsjdk.samtools.CRAMIterator;
import htsjdk.samtools.CachingBAMFileIndex;
import htsjdk.samtools.Chunk;
import htsjdk.samtools.Defaults;
import htsjdk.samtools.DiskBasedBAMFileIndex;
import htsjdk.samtools.QueryInterval;
import htsjdk.samtools.SAMException;
import htsjdk.samtools.SAMFileHeader;
import htsjdk.samtools.SAMFileSpan;
import htsjdk.samtools.SAMRecord;
import htsjdk.samtools.SAMRecordFactory;
import htsjdk.samtools.SAMRecordIterator;
import htsjdk.samtools.SAMSequenceDictionary;
import htsjdk.samtools.SamReader;
import htsjdk.samtools.ValidationStringency;
import htsjdk.samtools.cram.ref.ReferenceSource;
import htsjdk.samtools.cram.structure.Container;
import htsjdk.samtools.cram.structure.ContainerIO;
import htsjdk.samtools.seekablestream.SeekableFileStream;
import htsjdk.samtools.seekablestream.SeekableStream;
import htsjdk.samtools.util.CloseableIterator;
import htsjdk.samtools.util.CloserUtil;
import htsjdk.samtools.util.CoordMath;
import htsjdk.samtools.util.RuntimeEOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Iterator;

public class CRAMFileReader
extends SamReader.ReaderImplementation
implements SamReader.Indexing {
    private File cramFile;
    private final ReferenceSource referenceSource;
    private InputStream inputStream;
    private CRAMIterator iterator;
    private BAMIndex mIndex;
    private File mIndexFile;
    private boolean mEnableIndexCaching;
    private boolean mEnableIndexMemoryMapping;
    private ValidationStringency validationStringency;
    private static final SAMRecordIterator emptyIterator = new SAMRecordIterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        @Override
        public SAMRecord next() {
            throw new RuntimeException("No records.");
        }

        @Override
        public void remove() {
            throw new RuntimeException("Remove not supported.");
        }

        @Override
        public void close() {
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return this;
        }
    };

    public CRAMFileReader(File cramFile, InputStream inputStream) {
        this(cramFile, inputStream, new ReferenceSource(Defaults.REFERENCE_FASTA));
    }

    public CRAMFileReader(File cramFile, InputStream inputStream, ReferenceSource referenceSource) {
        if (cramFile == null && inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.cramFile = cramFile;
        this.inputStream = inputStream;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File cramFile, File indexFile, ReferenceSource referenceSource) {
        if (cramFile == null) {
            throw new IllegalArgumentException("File is required.");
        }
        this.cramFile = cramFile;
        this.mIndexFile = indexFile;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(File cramFile, ReferenceSource referenceSource) {
        if (cramFile == null && this.inputStream == null) {
            throw new IllegalArgumentException("Either file or input stream is required.");
        }
        this.cramFile = cramFile;
        this.referenceSource = referenceSource;
        this.getIterator();
    }

    public CRAMFileReader(InputStream inputStream, SeekableStream indexInputStream, ReferenceSource referenceSource, ValidationStringency validationStringency) throws IOException {
        this.inputStream = inputStream;
        this.referenceSource = referenceSource;
        this.validationStringency = validationStringency;
        this.iterator = new CRAMIterator(inputStream, referenceSource);
        this.iterator.setValidationStringency(validationStringency);
        if (indexInputStream != null) {
            this.mIndex = new CachingBAMFileIndex(indexInputStream, this.iterator.getSAMFileHeader().getSequenceDictionary());
        }
    }

    @Override
    void enableIndexCaching(boolean enabled) {
        this.mEnableIndexCaching = enabled;
    }

    @Override
    void enableIndexMemoryMapping(boolean enabled) {
        this.mEnableIndexMemoryMapping = enabled;
    }

    @Override
    void enableCrcChecking(boolean enabled) {
    }

    @Override
    void setSAMRecordFactory(SAMRecordFactory factory) {
    }

    @Override
    public boolean hasIndex() {
        return this.mIndex != null || this.mIndexFile != null;
    }

    @Override
    public BAMIndex getIndex() {
        if (!this.hasIndex()) {
            throw new SAMException("No index is available for this BAM file.");
        }
        if (this.mIndex == null) {
            SAMSequenceDictionary dictionary = this.getFileHeader().getSequenceDictionary();
            this.mIndex = this.mEnableIndexCaching ? new CachingBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping) : new DiskBasedBAMFileIndex(this.mIndexFile, dictionary, this.mEnableIndexMemoryMapping);
        }
        return this.mIndex;
    }

    @Override
    public boolean hasBrowseableIndex() {
        return false;
    }

    @Override
    public BrowseableBAMIndex getBrowseableIndex() {
        return null;
    }

    @Override
    public SAMRecordIterator iterator(SAMFileSpan fileSpan) {
        long[] coordinateArray = ((BAMFileSpan)fileSpan).toCoordinateArray();
        if (coordinateArray == null || coordinateArray.length == 0) {
            return emptyIterator;
        }
        try {
            SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
            return new CRAMIterator(seekableStream, this.referenceSource, coordinateArray);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public SAMFileHeader getFileHeader() {
        return this.iterator.getSAMFileHeader();
    }

    public SAMRecordIterator getIterator() {
        if (this.iterator != null && this.cramFile == null) {
            return this.iterator;
        }
        try {
            CRAMIterator newIterator = this.cramFile != null ? new CRAMIterator(new FileInputStream(this.cramFile), this.referenceSource) : new CRAMIterator(this.inputStream, this.referenceSource);
            newIterator.setValidationStringency(this.validationStringency);
            this.iterator = newIterator;
            return this.iterator;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public CloseableIterator<SAMRecord> getIterator(SAMFileSpan fileSpan) {
        return this.iterator(fileSpan);
    }

    @Override
    public SAMFileSpan getFilePointerSpanningReads() {
        return new BAMFileSpan(new Chunk(this.iterator.firstContainerOffset << 16, Long.MAX_VALUE));
    }

    @Override
    public CloseableIterator<SAMRecord> queryAlignmentStart(String sequence, int start) {
        long[] filePointers = null;
        SAMFileHeader fileHeader = this.getFileHeader();
        int referenceIndex = fileHeader.getSequenceIndex(sequence);
        if (referenceIndex != -1) {
            BAMIndex fileIndex = this.getIndex();
            BAMFileSpan fileSpan = fileIndex.getSpanOverlapping(referenceIndex, start, -1);
            long[] lArray = filePointers = fileSpan != null ? fileSpan.toCoordinateArray() : null;
        }
        if (filePointers == null || filePointers.length == 0) {
            return emptyIterator;
        }
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        for (int i = 0; i < filePointers.length; i += 2) {
            long containerOffset = filePointers[i] >>> 16;
            try {
                Container container;
                if (seekableStream.position() != containerOffset || this.iterator.container == null) {
                    seekableStream.seek(containerOffset);
                    container = ContainerIO.readContainerHeader(this.iterator.getCramHeader().getVersion().major, seekableStream);
                    if (container.alignmentStart + container.alignmentSpan <= start) continue;
                    seekableStream.seek(containerOffset);
                    this.iterator.jumpWithinContainerToPos(fileHeader.getSequenceIndex(sequence), start);
                    return new IntervalIterator(this.iterator, new QueryInterval(referenceIndex, start, -1));
                }
                container = this.iterator.container;
                if (container.alignmentStart + container.alignmentSpan <= start) continue;
                this.iterator.jumpWithinContainerToPos(fileHeader.getSequenceIndex(sequence), start);
                return new IntervalIterator(this.iterator, new QueryInterval(referenceIndex, start, -1));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return this.iterator;
    }

    CloseableIterator<SAMRecord> query(int referenceIndex, int start, int end, boolean overlap) throws IOException {
        long[] filePointers = null;
        if (referenceIndex != -1) {
            BAMIndex fileIndex = this.getIndex();
            BAMFileSpan fileSpan = fileIndex.getSpanOverlapping(referenceIndex, start, -1);
            long[] lArray = filePointers = fileSpan != null ? fileSpan.toCoordinateArray() : null;
        }
        if (filePointers == null || filePointers.length == 0) {
            return emptyIterator;
        }
        CRAMIterator newIterator = new CRAMIterator(this.getSeekableStreamOrFailWithRTE(), this.referenceSource, filePointers);
        return new IntervalIterator(newIterator, new QueryInterval(referenceIndex, start, end), overlap);
    }

    @Override
    public CloseableIterator<SAMRecord> queryUnmapped() {
        long startOfLastLinearBin = this.getIndex().getStartOfLastLinearBin();
        SeekableStream seekableStream = this.getSeekableStreamOrFailWithRTE();
        try {
            seekableStream.seek(0L);
            CRAMIterator newIterator = new CRAMIterator(seekableStream, this.referenceSource);
            newIterator.setValidationStringency(this.validationStringency);
            seekableStream.seek(startOfLastLinearBin >>> 16);
            Container container = ContainerIO.readContainerHeader(newIterator.getCramHeader().getVersion().major, seekableStream);
            seekableStream.seek(seekableStream.position() + (long)container.containerByteSize);
            this.iterator = newIterator;
            this.iterator.jumpWithinContainerToPos(-1, 0);
        }
        catch (IOException e) {
            throw new RuntimeEOFException(e);
        }
        return this.iterator;
    }

    private SeekableStream getSeekableStreamOrFailWithRTE() {
        SeekableStream seekableStream = null;
        if (this.cramFile != null) {
            try {
                seekableStream = new SeekableFileStream(this.cramFile);
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        } else if (this.inputStream instanceof SeekableStream) {
            seekableStream = (SeekableStream)this.inputStream;
        }
        return seekableStream;
    }

    @Override
    public void close() {
        CloserUtil.close(this.iterator);
        CloserUtil.close(this.inputStream);
        CloserUtil.close(this.mIndex);
    }

    @Override
    void setValidationStringency(ValidationStringency validationStringency) {
        this.validationStringency = validationStringency;
        if (this.iterator != null) {
            this.iterator.setValidationStringency(validationStringency);
        }
    }

    @Override
    public ValidationStringency getValidationStringency() {
        return this.validationStringency;
    }

    @Override
    public CloseableIterator<SAMRecord> query(QueryInterval[] intervals, boolean contained) {
        return new MultiIntervalIterator(Arrays.asList(intervals).iterator(), !contained);
    }

    @Override
    public SamReader.Type type() {
        return SamReader.Type.CRAM_TYPE;
    }

    @Override
    void enableFileSource(SamReader reader, boolean enabled) {
        if (this.iterator != null) {
            this.iterator.setFileSource(enabled ? reader : null);
        }
    }

    public static class IntervalIterator
    implements SAMRecordIterator {
        private final CloseableIterator<SAMRecord> delegate;
        private final QueryInterval interval;
        private SAMRecord next;
        private boolean noMore = false;
        private final boolean overlap;

        public IntervalIterator(CloseableIterator<SAMRecord> delegate, QueryInterval interval) {
            this(delegate, interval, true);
        }

        public IntervalIterator(CloseableIterator<SAMRecord> delegate, QueryInterval interval, boolean overlap) {
            this.delegate = delegate;
            this.interval = interval;
            this.overlap = overlap;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return null;
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            if (this.next != null) {
                return true;
            }
            if (this.noMore) {
                return false;
            }
            while (this.delegate.hasNext()) {
                this.next = (SAMRecord)this.delegate.next();
                if (this.isWithinTheInterval(this.next)) break;
                if (this.isBeyondTheInterval(this.next)) {
                    this.next = null;
                    this.noMore = true;
                    return false;
                }
                this.next = null;
            }
            return this.next != null;
        }

        boolean isWithinTheInterval(SAMRecord record) {
            boolean refMatch;
            boolean bl = refMatch = record.getReferenceIndex() == this.interval.referenceIndex;
            if (this.interval.start == -1) {
                return refMatch;
            }
            int start = record.getAlignmentStart();
            int end = record.getAlignmentEnd();
            if (this.overlap) {
                return CoordMath.overlaps(start, end, this.interval.start, this.interval.end < 0 ? Integer.MAX_VALUE : this.interval.end);
            }
            return CoordMath.encloses(this.interval.start, this.interval.end < 0 ? Integer.MAX_VALUE : this.interval.end, start, end);
        }

        boolean isBeyondTheInterval(SAMRecord record) {
            if (record.getReadUnmappedFlag()) {
                return false;
            }
            boolean refMatch = record.getReferenceIndex() == this.interval.referenceIndex;
            return !refMatch || this.interval.end != -1 && record.getAlignmentStart() > this.interval.end;
        }

        @Override
        public SAMRecord next() {
            SAMRecord result = this.next;
            this.next = null;
            return result;
        }

        @Override
        public void remove() {
            throw new RuntimeException("Not available.");
        }
    }

    private class MultiIntervalIterator
    implements SAMRecordIterator {
        private final Iterator<QueryInterval> queries;
        private CloseableIterator<SAMRecord> iterator;
        private final boolean overlap;

        public MultiIntervalIterator(Iterator<QueryInterval> queries, boolean overlap) {
            this.queries = queries;
            this.overlap = overlap;
        }

        @Override
        public SAMRecordIterator assertSorted(SAMFileHeader.SortOrder sortOrder) {
            return null;
        }

        @Override
        public void close() {
        }

        @Override
        public boolean hasNext() {
            if (this.iterator == null || !this.iterator.hasNext()) {
                if (!this.queries.hasNext()) {
                    return false;
                }
                do {
                    QueryInterval query = this.queries.next();
                    try {
                        this.iterator = CRAMFileReader.this.query(query.referenceIndex, query.start, query.end, this.overlap);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                } while (!this.iterator.hasNext() && this.queries.hasNext());
            }
            return this.iterator.hasNext();
        }

        @Override
        public SAMRecord next() {
            return (SAMRecord)this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

