/*
 * Decompiled with CFR 0.152.
 */
package cern.jet.random;

import cern.jet.math.Arithmetic;
import cern.jet.random.AbstractDiscreteDistribution;
import cern.jet.random.AbstractDistribution;
import edu.cornell.lassp.houle.RngPack.RandomElement;

public class HyperGeometric
extends AbstractDiscreteDistribution {
    protected int my_N;
    protected int my_s;
    protected int my_n;
    private int N_last = -1;
    private int M_last = -1;
    private int n_last = -1;
    private int N_Mn;
    private int m;
    private int mp;
    private int b;
    private double Mp;
    private double np;
    private double fm;
    private int k2;
    private int k4;
    private int k1;
    private int k5;
    private double dl;
    private double dr;
    private double r1;
    private double r2;
    private double r4;
    private double r5;
    private double ll;
    private double lr;
    private double c_pm;
    private double f1;
    private double f2;
    private double f4;
    private double f5;
    private double p1;
    private double p2;
    private double p3;
    private double p4;
    private double p5;
    private double p6;
    protected static HyperGeometric shared = new HyperGeometric(1, 1, 1, AbstractDistribution.makeDefaultGenerator());

    public HyperGeometric(int n, int n2, int n3, RandomElement randomElement) {
        this.setRandomGenerator(randomElement);
        this.setState(n, n2, n3);
    }

    private static double fc_lnpk(int n, int n2, int n3, int n4) {
        return Arithmetic.logFactorial(n) + Arithmetic.logFactorial(n3 - n) + Arithmetic.logFactorial(n4 - n) + Arithmetic.logFactorial(n2 + n);
    }

    protected int hmdu(int n, int n2, int n3, RandomElement randomElement) {
        if (n != this.N_last || n2 != this.M_last || n3 != this.n_last) {
            this.N_last = n;
            this.M_last = n2;
            this.n_last = n3;
            this.Mp = n2 + 1;
            this.np = n3 + 1;
            this.N_Mn = n - n2 - n3;
            double d = this.Mp / ((double)n + 2.0);
            double d2 = this.np * d;
            this.m = (int)d2;
            this.mp = (double)this.m == d2 && d == 0.5 ? this.m-- : this.m + 1;
            this.fm = Math.exp(Arithmetic.logFactorial(n - n2) - Arithmetic.logFactorial(this.N_Mn + this.m) - Arithmetic.logFactorial(n3 - this.m) + Arithmetic.logFactorial(n2) - Arithmetic.logFactorial(n2 - this.m) - Arithmetic.logFactorial(this.m) - Arithmetic.logFactorial(n) + Arithmetic.logFactorial(n - n3) + Arithmetic.logFactorial(n3));
            this.b = (int)(d2 + 11.0 * Math.sqrt(d2 * (1.0 - d) * (1.0 - (double)n3 / (double)n) + 1.0));
            if (this.b > n3) {
                this.b = n3;
            }
        }
        block0: while (true) {
            int n4;
            double d;
            double d3;
            double d4 = randomElement.raw() - this.fm;
            if (d3 <= 0.0) {
                return this.m;
            }
            double d5 = d = this.fm;
            int n5 = 1;
            while (n5 <= this.m) {
                double d6;
                double d7;
                n4 = this.mp - n5;
                d4 -= (d5 *= (double)n4 / (this.np - (double)n4) * ((double)(this.N_Mn + n4) / (this.Mp - (double)n4)));
                if (d7 <= 0.0) {
                    return n4 - 1;
                }
                n4 = this.m + n5;
                d4 -= (d *= (this.np - (double)n4) / (double)n4 * ((this.Mp - (double)n4) / (double)(this.N_Mn + n4)));
                if (d6 <= 0.0) {
                    return n4;
                }
                ++n5;
            }
            n4 = this.mp + this.m;
            while (true) {
                double d8;
                if (n4 > this.b) continue block0;
                d4 -= (d *= (this.np - (double)n4) / (double)n4 * ((this.Mp - (double)n4) / (double)(this.N_Mn + n4)));
                if (d8 <= 0.0) {
                    return n4;
                }
                ++n4;
            }
            break;
        }
    }

    protected int hprs(int n, int n2, int n3, RandomElement randomElement) {
        int n4;
        double d;
        if (n != this.N_last || n2 != this.M_last || n3 != this.n_last) {
            this.N_last = n;
            this.M_last = n2;
            this.n_last = n3;
            double d2 = n2 + 1;
            double d3 = n3 + 1;
            this.N_Mn = n - n2 - n3;
            double d4 = d2 / ((double)n + 2.0);
            double d5 = d3 * d4;
            d = Math.sqrt(d5 * (1.0 - d4) * (1.0 - ((double)n3 + 2.0) / ((double)n + 3.0)) + 0.25);
            this.m = (int)d5;
            this.k2 = (int)Math.ceil(d5 - 0.5 - d);
            if (this.k2 >= this.m) {
                this.k2 = this.m - 1;
            }
            this.k4 = (int)(d5 - 0.5 + d);
            this.k1 = this.k2 + this.k2 - this.m + 1;
            this.k5 = this.k4 + this.k4 - this.m;
            this.dl = this.k2 - this.k1;
            this.dr = this.k5 - this.k4;
            this.r1 = (d3 / (double)this.k1 - 1.0) * (d2 - (double)this.k1) / (double)(this.N_Mn + this.k1);
            this.r2 = (d3 / (double)this.k2 - 1.0) * (d2 - (double)this.k2) / (double)(this.N_Mn + this.k2);
            this.r4 = (d3 / (double)(this.k4 + 1) - 1.0) * (double)(n2 - this.k4) / (double)(this.N_Mn + this.k4 + 1);
            this.r5 = (d3 / (double)(this.k5 + 1) - 1.0) * (double)(n2 - this.k5) / (double)(this.N_Mn + this.k5 + 1);
            this.ll = Math.log(this.r1);
            this.lr = -Math.log(this.r5);
            this.c_pm = HyperGeometric.fc_lnpk(this.m, this.N_Mn, n2, n3);
            this.f2 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k2, this.N_Mn, n2, n3));
            this.f4 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k4, this.N_Mn, n2, n3));
            this.f1 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k1, this.N_Mn, n2, n3));
            this.f5 = Math.exp(this.c_pm - HyperGeometric.fc_lnpk(this.k5, this.N_Mn, n2, n3));
            this.p1 = this.f2 * (this.dl + 1.0);
            this.p2 = this.f2 * this.dl + this.p1;
            this.p3 = this.f4 * (this.dr + 1.0) + this.p2;
            this.p4 = this.f4 * this.dr + this.p3;
            this.p5 = this.f1 / this.ll + this.p4;
            this.p6 = this.f5 / this.lr + this.p5;
        }
        while (true) {
            int n5;
            int n6;
            double d6;
            double d7;
            double d8;
            d = randomElement.raw() * this.p6;
            if (d8 < this.p2) {
                double d9;
                double d10;
                double d11;
                d7 = d - this.p1;
                if (d11 < 0.0) {
                    return this.k2 + (int)(d / this.f2);
                }
                d6 = d7 / this.dl;
                if (d10 < this.f1) {
                    return this.k1 + (int)(d7 / this.f1);
                }
                n6 = (int)(this.dl * randomElement.raw()) + 1;
                if (d6 <= this.f2 - (double)n6 * (this.f2 - this.f2 / this.r2)) {
                    return this.k2 - n6;
                }
                d7 = this.f2 + this.f2 - d6;
                if (d9 < 1.0) {
                    n5 = this.k2 + n6;
                    if (d7 <= this.f2 + (double)n6 * (1.0 - this.f2) / (this.dl + 1.0)) {
                        return n5;
                    }
                    if (Math.log(d7) <= this.c_pm - HyperGeometric.fc_lnpk(n5, this.N_Mn, n2, n3)) {
                        return n5;
                    }
                }
                n4 = this.k2 - n6;
            } else if (d < this.p4) {
                double d12;
                double d13;
                double d14;
                d7 = d - this.p3;
                if (d14 < 0.0) {
                    return this.k4 - (int)((d - this.p2) / this.f4);
                }
                d6 = d7 / this.dr;
                if (d13 < this.f5) {
                    return this.k5 - (int)(d7 / this.f5);
                }
                n6 = (int)(this.dr * randomElement.raw()) + 1;
                if (d6 <= this.f4 - (double)n6 * (this.f4 - this.f4 * this.r4)) {
                    return this.k4 + n6;
                }
                d7 = this.f4 + this.f4 - d6;
                if (d12 < 1.0) {
                    n5 = this.k4 - n6;
                    if (d7 <= this.f4 + (double)n6 * (1.0 - this.f4) / this.dr) {
                        return n5;
                    }
                    if (Math.log(d7) <= this.c_pm - HyperGeometric.fc_lnpk(n5, this.N_Mn, n2, n3)) {
                        return n5;
                    }
                }
                n4 = this.k4 + n6;
            } else {
                d6 = randomElement.raw();
                if (d < this.p5) {
                    n6 = (int)(1.0 - Math.log(d6) / this.ll);
                    n4 = this.k1 - n6;
                    if (n4 < 0) continue;
                    if ((d6 *= (d - this.p4) * this.ll) <= this.f1 - (double)n6 * (this.f1 - this.f1 / this.r1)) {
                        return n4;
                    }
                } else {
                    n6 = (int)(1.0 - Math.log(d6) / this.lr);
                    n4 = this.k5 + n6;
                    if (n4 > n3) continue;
                    if ((d6 *= (d - this.p5) * this.lr) <= this.f5 - (double)n6 * (this.f5 - this.f5 * this.r5)) {
                        return n4;
                    }
                }
            }
            if (Math.log(d6) <= this.c_pm - HyperGeometric.fc_lnpk(n4, this.N_Mn, n2, n3)) break;
        }
        return n4;
    }

    public int nextInt() {
        return this.nextInt(this.my_N, this.my_s, this.my_n, this.randomGenerator);
    }

    public int nextInt(int n, int n2, int n3) {
        return this.nextInt(n, n2, n3, this.randomGenerator);
    }

    protected int nextInt(int n, int n2, int n3, RandomElement randomElement) {
        int n4;
        int n5;
        int n6 = n / 2;
        int n7 = n3 <= n6 ? n3 : n - n3;
        int n8 = n5 = n2 <= n6 ? n2 : n - n2;
        if (n3 * n2 / n < 10) {
            n4 = n7 <= n5 ? this.hmdu(n, n5, n7, randomElement) : this.hmdu(n, n7, n5, randomElement);
        } else {
            int n9 = n4 = n7 <= n5 ? this.hprs(n, n5, n7, randomElement) : this.hprs(n, n7, n5, randomElement);
        }
        if (n3 <= n6) {
            return n2 <= n6 ? n4 : n3 - n4;
        }
        return n2 <= n6 ? n2 - n4 : n3 - n + n2 + n4;
    }

    public double pdf(int n) {
        return Arithmetic.binomial(this.my_s, (long)n) * Arithmetic.binomial(this.my_N - this.my_s, (long)(this.my_n - n)) / Arithmetic.binomial(this.my_N, (long)this.my_n);
    }

    public void setState(int n, int n2, int n3) {
        this.my_N = n;
        this.my_s = n2;
        this.my_n = n3;
    }

    public static double staticNextInt(int n, int n2, int n3) {
        HyperGeometric hyperGeometric = shared;
        synchronized (hyperGeometric) {
            double d = shared.nextInt(n, n2, n3);
            return d;
        }
    }

    public String toString() {
        return this.getClass().getName() + "(" + this.my_N + "," + this.my_s + "," + this.my_n + ")";
    }

    private static void xstaticSetRandomGenerator(RandomElement randomElement) {
        HyperGeometric hyperGeometric = shared;
        synchronized (hyperGeometric) {
            shared.setRandomGenerator(randomElement);
        }
    }
}

