## ----install, eval=FALSE------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("TaxSEA")

## ----example1-----------------------------------------------------------------
library(TaxSEA)

# Retrieve taxon sets containing Bifidobacterium longum.
blong.sets <- get_taxon_sets(taxon="Bifidobacterium_longum")

## ----input_data---------------------------------------------------------------
#Input IDs with the full taxonomic lineage should be split up. E.g.
x <- paste0(
  "d__Bacteria.p__Actinobacteriota.c__Actinomycetes.",
  "o__Bifidobacteriales.f__Bifidobacteriaceae.g__Bifidobacterium")
x = strsplit(x,split="\\.")[[1]][6]
x = gsub("g__","",x)
print(x)

## Example test data
library(TaxSEA)
data(TaxSEA_test_data)
head(sample(TaxSEA_test_data),4)


## ----example2-----------------------------------------------------------------
data("TaxSEA_test_data")
taxsea_results <- TaxSEA(taxon_ranks=TaxSEA_test_data)

#Enrichments among metabolite producers from gutMgene and MiMeDB
metabolites.df = taxsea_results$Metabolite_producers

#Enrichments among health and disease signatures from GMRepoV2 and mBodyMap
disease.df = taxsea_results$Health_associations

#Enrichments amongh published associations from BugSigDB
bsdb.df = taxsea_results$BugSigdB


## ----bugsigdb-----------------------------------------------------------------
library(bugsigdbr) #This package is installable via Bioconductor
bsdb <- importBugSigDB() #Import database 

#E.g. if the BugSigDB identifier you found enriched was 
#bsdb:74/1/2_obesity:obese_vs_non-obese_DOWN
#This is Study 74, Experiment 1, Signature 2
bsdb[bsdb$Study=="Study 74" & 
     bsdb$Experiment=="Experiment 1" & 
     bsdb$Signature=="Signature 2",]


## ----fgsea--------------------------------------------------------------------
library(fgsea) #This package is installable via Bioconductor
data("TaxSEA_test_data")
data("TaxSEA_db")
#Convert input names to NCBI taxon ids
names(TaxSEA_test_data) = get_ncbi_taxon_ids(names(TaxSEA_test_data))
TaxSEA_test_data = TaxSEA_test_data[!is.na(names(TaxSEA_test_data))]

#Run fgsea
fgsea_results <- fgsea(TaxSEA_db, TaxSEA_test_data, minSize=5, maxSize=500)

## ----sessioninfo--------------------------------------------------------------
sessionInfo()

