/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.file;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import org.bridgedb.IDMapperException;
import org.bridgedb.file.IDMappingReaderFromDelimitedReader;
import org.bridgedb.impl.InternalUtils;

public class IDMappingReaderFromText
extends IDMappingReaderFromDelimitedReader {
    protected final URL url;

    public IDMappingReaderFromText(URL url, char[] dataSourceDelimiters) throws IDMapperException {
        this(url, dataSourceDelimiters, null);
    }

    public IDMappingReaderFromText(URL url, char[] dataSourceDelimiters, char[] regExIDDelimiter) throws IDMapperException {
        this(url, dataSourceDelimiters, regExIDDelimiter, false);
    }

    public IDMappingReaderFromText(URL url, char[] dataSourceDelimiters, char[] regExIDDelimiter, boolean transitivity) throws IDMapperException {
        this(url, IDMappingReaderFromText.strs2regex(dataSourceDelimiters), IDMappingReaderFromText.strs2regex(regExIDDelimiter), transitivity);
    }

    public IDMappingReaderFromText(URL url, String regExDataSourceDelimiter) throws IDMapperException {
        this(url, regExDataSourceDelimiter, null);
    }

    public IDMappingReaderFromText(URL url, String regExDataSourceDelimiter, String regExIDDelimiter) throws IDMapperException {
        this(url, regExDataSourceDelimiter, regExIDDelimiter, false);
    }

    public IDMappingReaderFromText(URL url, String regExDataSourceDelimiter, String regExIDDelimiter, boolean transitivity) throws IDMapperException {
        super(IDMappingReaderFromText.getReader(url), regExDataSourceDelimiter, regExIDDelimiter, transitivity);
        this.url = url;
    }

    public void setDataSourceDelimiters(char[] dataSourceDelimiters) {
        this.dsValid = false;
        this.idMappingValid = false;
        this.regExDataSourceDelimiter = IDMappingReaderFromText.strs2regex(dataSourceDelimiters);
    }

    public void setIDDelimiters(char[] idDelimiters) {
        this.idMappingValid = false;
        this.regExIDDelimiter = IDMappingReaderFromText.strs2regex(idDelimiters);
    }

    protected static String strs2regex(char[] chs) {
        if (chs == null || chs.length == 0) {
            return null;
        }
        StringBuilder regex = new StringBuilder();
        int n = chs.length;
        if (n > 0) {
            regex.append("[");
            for (int i = 0; i < n; ++i) {
                regex.append("\\0" + Integer.toOctalString(chs[i]));
            }
            regex.append("]");
        }
        return regex.toString();
    }

    private static Reader getReader(URL url) throws IDMapperException {
        try {
            InputStream inputStream = InternalUtils.getInputStream(url);
            return new InputStreamReader(inputStream);
        }
        catch (IOException e) {
            throw new IDMapperException(e);
        }
    }
}

