/*
 * Decompiled with CFR 0.152.
 */
package edu.msu.cme.rdp.classifier.train.validation;

import edu.msu.cme.rdp.classifier.train.LineageSequence;
import edu.msu.cme.rdp.classifier.train.validation.HierarchyTree;
import edu.msu.cme.rdp.classifier.train.validation.Taxonomy;
import edu.msu.cme.rdp.readseq.utils.orientation.GoodWordIterator;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;

public class TreeFactory {
    private HierarchyTree root;
    private HashMap<String, ArrayList> taxidMap = new HashMap();
    private Set<String> rankSet = new HashSet<String>();
    private float[] wordPriorArr = new float[(int)Math.pow(4.0, GoodWordIterator.getWordsize())];
    private int totalSequences = 0;
    private final float WF1 = 0.5f;
    private final float WF2 = 1.0f;
    private final int ROOT_DEPTH = 0;
    private String lowest_rank = null;

    public TreeFactory(Reader taxReader) throws IOException {
        this.creatTaxidMap(taxReader);
    }

    private void creatTaxidMap(Reader taxReader) throws IOException {
        String line;
        BufferedReader reader = new BufferedReader(taxReader);
        while ((line = reader.readLine()) != null) {
            if (line.length() == 0) continue;
            StringTokenizer st = new StringTokenizer(line, "*");
            if (st.countTokens() < 5) {
                throw new IllegalArgumentException("\nIllegal taxonomy format at " + line);
            }
            try {
                int taxid = Integer.parseInt(st.nextToken());
                String taxname = st.nextToken();
                int pid = Integer.parseInt(st.nextToken());
                int depth = Integer.parseInt(st.nextToken());
                ArrayList<Taxonomy> taxList = this.taxidMap.get(taxname);
                if (taxList == null) {
                    taxList = new ArrayList<Taxonomy>();
                    this.taxidMap.put(taxname, taxList);
                }
                Taxonomy tax = new Taxonomy(taxid, taxname, pid, depth, st.nextToken().trim());
                taxList.add(tax);
                if (tax.depth != this.ROOT_DEPTH) continue;
                if (this.root == null) {
                    this.root = new HierarchyTree(taxname, null, tax);
                    continue;
                }
                throw new IllegalArgumentException("Error: taxon " + tax.getTaxID() + " has the depth set to '0'. Only the root taxon can have the depth set to '0'");
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("\nError: The value for taxid, parentid and the depth should be integer in : " + line);
            }
        }
        if (this.root == null) {
            throw new IllegalArgumentException("Error: no root taxon with depth '0' defined in the taxonomy file.");
        }
    }

    public void buildTree() {
        HashMap<Integer, HierarchyTree> nodesBuilt = new HashMap<Integer, HierarchyTree>();
        nodesBuilt.put(this.root.getTaxonomy().getTaxID(), this.root);
        HashMap<Integer, Taxonomy> tempMap = new HashMap<Integer, Taxonomy>();
        for (ArrayList taxonList : this.taxidMap.values()) {
            for (Taxonomy taxon : taxonList) {
                tempMap.put(taxon.taxID, taxon);
            }
        }
        for (Taxonomy taxon : tempMap.values()) {
            if (nodesBuilt.containsKey(taxon.getTaxID())) continue;
            Stack<Taxonomy> missingNodes = new Stack<Taxonomy>();
            missingNodes.push(taxon);
            Taxonomy parentTaxon = (Taxonomy)tempMap.get(taxon.getParentID());
            HierarchyTree parent = (HierarchyTree)nodesBuilt.get(parentTaxon.getTaxID());
            while (parent == null) {
                missingNodes.push(parentTaxon);
                parentTaxon = (Taxonomy)tempMap.get(parentTaxon.getParentID());
                parent = (HierarchyTree)nodesBuilt.get(parentTaxon.getTaxID());
            }
            while (!missingNodes.empty()) {
                Taxonomy temp = (Taxonomy)missingNodes.pop();
                HierarchyTree tempTree = new HierarchyTree(temp.getName(), parent, temp);
                nodesBuilt.put(tempTree.getTaxonomy().getTaxID(), tempTree);
                parent = tempTree;
            }
        }
    }

    public HierarchyTree addSequence(LineageSequence pSeq) throws IOException {
        return this.addSequence(pSeq, true);
    }

    public HierarchyTree addSequence(LineageSequence pSeq, boolean initWordOccurrence) throws IOException {
        int size = pSeq.getAncestors().size();
        if (size == 0) {
            throw new IllegalStateException("Sequence " + pSeq.getSeqName() + " does not have ancestors\n");
        }
        if (!pSeq.getAncestors().get(0).equals(this.root.getName())) {
            throw new IllegalArgumentException("Sequence " + pSeq.getSeqName() + " has conflicting root name. root is " + this.root.getName());
        }
        HierarchyTree curTree = this.root;
        this.rankSet.add(curTree.getTaxonomy().hierLevel);
        for (int i = 1; i < size; ++i) {
            HierarchyTree tmp = curTree.getSubclassbyName(pSeq.getAncestors().get(i));
            if (tmp == null) {
                Taxonomy tax = this.getTaxonomy(pSeq.getSeqName(), pSeq.getAncestors().get(i), curTree.getTaxonomy().taxID, i);
                curTree = new HierarchyTree(pSeq.getAncestors().get(i), curTree, tax);
                this.rankSet.add(tax.hierLevel);
            } else {
                curTree = tmp;
            }
            if (i != size - 1) continue;
            curTree.initWordOccurrence(pSeq, this.wordPriorArr, initWordOccurrence);
            curTree.increTotalSeqs();
            ++this.totalSequences;
            if (this.lowest_rank == null) {
                this.lowest_rank = curTree.getTaxonomy().hierLevel.toUpperCase();
                continue;
            }
            if (this.lowest_rank.equalsIgnoreCase(curTree.getTaxonomy().getHierLevel())) continue;
            throw new IllegalArgumentException("Sequence " + pSeq.getSeqName() + " has different lowest rank: " + curTree.getTaxonomy().getHierLevel() + " from the previous lowest rank: " + this.lowest_rank);
        }
        return curTree;
    }

    public Taxonomy getTaxonomy(String seqName, String ancestorName, int pid, int index) {
        if (ancestorName == null) {
            throw new IllegalArgumentException("Error: No ancestors found for sequence: " + seqName + "! Please check the source file.");
        }
        ArrayList taxList = this.taxidMap.get(ancestorName);
        if (taxList == null) {
            throw new IllegalArgumentException("\nThe taxID for ancestor '" + ancestorName + "' of sequence '" + seqName + "' at depth '" + index + "' with parent id '" + pid + "' is not found!");
        }
        Taxonomy result = null;
        for (int i = 0; i < taxList.size(); ++i) {
            Taxonomy tax = (Taxonomy)taxList.get(i);
            if (tax.parentID != pid || tax.depth != index) continue;
            result = tax;
            break;
        }
        if (result == null) {
            throw new IllegalArgumentException("\nThe taxID for ancestor '" + ancestorName + "' of sequence '" + seqName + "' at depth '" + index + "' with parent id '" + pid + "' is not found!");
        }
        return result;
    }

    public HierarchyTree getRoot() {
        return this.root;
    }

    public Set<String> getRankSet() {
        return this.rankSet;
    }

    public String getLowestRank() {
        return this.lowest_rank;
    }

    public void displayTreePhylo(HierarchyTree root, String index, int indent) {
        if (root.isSingleton()) {
            System.out.println(root.getTaxonomy().getHierLevel() + " " + root.getName());
        }
        Iterator<HierarchyTree> i = root.getSubclasses().iterator();
        int curNum = 1;
        while (i.hasNext()) {
            this.displayTreePhylo(i.next(), index + "." + curNum, indent + 1);
            ++curNum;
        }
    }

    public void calculateWordPrior() {
        for (int i = 0; i < this.wordPriorArr.length; ++i) {
            this.wordPriorArr[i] = (this.wordPriorArr[i] + 0.5f) / ((float)this.totalSequences + 1.0f);
        }
    }

    public void printWordPriors() throws IOException {
        BufferedWriter outfile = new BufferedWriter(new FileWriter("wordPrior.txt"));
        outfile.write("word \t Prior\n");
        for (int i = 0; i < this.wordPriorArr.length; ++i) {
            outfile.write(i + "\t" + this.wordPriorArr[i] + "\n");
        }
        outfile.close();
    }

    public float getWordPrior(int wordIndex) {
        return this.wordPriorArr[wordIndex];
    }
}

