/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.utils.bytecode;

import java.lang.reflect.Method;
import org.biojava.utils.bytecode.CodeClass;
import org.biojava.utils.bytecode.CodeMethod;
import org.biojava.utils.bytecode.IntrospectedCodeClass;

class IntrospectedCodeMethod
implements CodeMethod {
    private final Method _method;

    public IntrospectedCodeMethod(Method method) {
        this._method = method;
    }

    public String getName() {
        return this._method.getName();
    }

    public String getFullName() {
        return this._method.getDeclaringClass().getName() + "." + this.getName();
    }

    public CodeClass getContainingClass() {
        return IntrospectedCodeClass.forClass(this._method.getDeclaringClass());
    }

    public String getDescriptor() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append('(');
        int n = 0;
        while (n < this.numParameters()) {
            CodeClass codeClass = this.getParameterType(n);
            stringBuffer.append(codeClass.getDescriptor());
            ++n;
        }
        stringBuffer.append(')');
        stringBuffer.append(this.getReturnType().getDescriptor());
        return stringBuffer.toString();
    }

    public int getModifiers() {
        return this._method.getModifiers();
    }

    public CodeClass getReturnType() {
        return IntrospectedCodeClass.forClass(this._method.getReturnType());
    }

    public int numParameters() {
        return this._method.getParameterTypes().length;
    }

    public CodeClass getParameterType(int n) {
        return IntrospectedCodeClass.forClass(this._method.getParameterTypes()[n]);
    }

    public String toString() {
        return super.toString() + " " + this.getDescriptor();
    }
}

