/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.NotSerializableException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.Edit;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.Changeable;
import org.biojava.utils.StaticMemberPlaceHolder;

public interface SymbolList
extends Changeable {
    public static final ChangeType EDIT = new ChangeType("the SymbolList has been edited", "org.biojava.bio.symbol.SymbolList", "EDIT");
    public static final SymbolList EMPTY_LIST = new EmptySymbolList();

    public void edit(Edit var1) throws IndexOutOfBoundsException, IllegalAlphabetException, ChangeVetoException;

    public Alphabet getAlphabet();

    public Iterator iterator();

    public int length();

    public String seqString();

    public SymbolList subList(int var1, int var2) throws IndexOutOfBoundsException;

    public String subStr(int var1, int var2) throws IndexOutOfBoundsException;

    public Symbol symbolAt(int var1) throws IndexOutOfBoundsException;

    public List toList();

    public static class EmptySymbolList
    implements SymbolList,
    Serializable {
        static /* synthetic */ Class class$org$biojava$bio$symbol$SymbolList;

        public void addChangeListener(ChangeListener changeListener) {
        }

        public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }

        public void edit(Edit edit) throws IndexOutOfBoundsException, ChangeVetoException {
            throw new ChangeVetoException("You can't edit the empty symbol list");
        }

        public Alphabet getAlphabet() {
            return Alphabet.EMPTY_ALPHABET;
        }

        public Iterator iterator() {
            return Collections.EMPTY_LIST.iterator();
        }

        public int length() {
            return 0;
        }

        public void removeChangeListener(ChangeListener changeListener) {
        }

        public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        }

        public String seqString() {
            return "";
        }

        public SymbolList subList(int n, int n2) throws IndexOutOfBoundsException {
            Collections.EMPTY_LIST.subList(n - 1, n2);
            return EMPTY_LIST;
        }

        public String subStr(int n, int n2) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("You can not retrieve part of an empty symbol list");
        }

        public Symbol symbolAt(int n) throws IndexOutOfBoundsException {
            throw new IndexOutOfBoundsException("Attempted to retrieve symbol from empty list at " + n);
        }

        public List toList() {
            return Collections.EMPTY_LIST;
        }

        private Object writeReplace() throws ObjectStreamException {
            try {
                return new StaticMemberPlaceHolder((class$org$biojava$bio$symbol$SymbolList != null ? class$org$biojava$bio$symbol$SymbolList : (class$org$biojava$bio$symbol$SymbolList = EmptySymbolList.class$("org.biojava.bio.symbol.SymbolList"))).getField("EMPTY_LIST"));
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new NotSerializableException(noSuchFieldException.getMessage());
            }
        }
    }
}

