/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.HashSet;
import java.util.Set;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqFileFormer;
import org.biojava.bio.seq.io.SeqFileFormerFactory;
import org.biojava.bio.seq.io.SeqIOEventEmitter;
import org.biojava.bio.seq.io.SeqIOListener;
import org.biojava.bio.seq.io.SequenceFormat;
import org.biojava.bio.seq.io.StreamParser;
import org.biojava.bio.seq.io.SymbolParser;
import org.biojava.bio.symbol.IllegalSymbolException;

public class EmblLikeFormat
implements SequenceFormat,
Serializable {
    private boolean elideSymbols = false;
    static /* synthetic */ Class class$org$biojava$bio$seq$io$EmblLikeFormat;

    static {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.add("Embl");
        SequenceFormat.FORMATS.put((class$org$biojava$bio$seq$io$EmblLikeFormat != null ? class$org$biojava$bio$seq$io$EmblLikeFormat : (class$org$biojava$bio$seq$io$EmblLikeFormat = EmblLikeFormat.class$("org.biojava.bio.seq.io.EmblLikeFormat"))).getName(), hashSet);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public String getDefaultFormat() {
        return "Embl";
    }

    public boolean getElideSymbols() {
        return this.elideSymbols;
    }

    public Set getFormats() {
        return (Set)SequenceFormat.FORMATS.get(this.getClass().getName());
    }

    /*
     * Unable to fully structure code
     */
    protected void processSequenceLine(String var1_1, StreamParser var2_2) throws IllegalSymbolException, ParseException {
        var3_3 = var1_1.toCharArray();
        var4_4 = 0;
        var5_5 = 0;
        ** GOTO lbl17
        {
            ++var4_4;
            do {
                if (var4_4 < var3_3.length && var3_3[var4_4] == ' ') continue block0;
                if (var4_4 >= var3_3.length) break block0;
                if (Character.isDigit(var3_3[var4_4])) {
                    return;
                }
                var5_5 = var4_4 + 1;
                while (var5_5 < var3_3.length && var3_3[var5_5] != ' ') {
                    ++var5_5;
                }
                var2_2.characters(var3_3, var4_4, var5_5 - var4_4);
                var4_4 = var5_5;
lbl17:
                // 2 sources

            } while (var4_4 < var3_3.length);
        }
    }

    public boolean readSequence(BufferedReader bufferedReader, SymbolParser symbolParser, SeqIOListener seqIOListener) throws IllegalSymbolException, IOException, ParseException {
        String string;
        StreamParser streamParser = null;
        boolean bl = true;
        seqIOListener.startSequence();
        while ((string = bufferedReader.readLine()) != null) {
            if (string.startsWith("//")) {
                if (streamParser != null) {
                    streamParser.close();
                    streamParser = null;
                }
                bufferedReader.mark(2);
                if (bufferedReader.read() == -1) {
                    bl = false;
                } else {
                    bufferedReader.reset();
                }
                seqIOListener.endSequence();
                return bl;
            }
            if (string.startsWith("SQ")) {
                seqIOListener.addSequenceProperty("XX", "");
                streamParser = symbolParser.parseStream(seqIOListener);
                continue;
            }
            if (streamParser == null) {
                String string2 = string.substring(0, 2);
                String string3 = null;
                if (string.length() > 5) {
                    string3 = string.substring(5);
                }
                seqIOListener.addSequenceProperty(string2, string3);
                continue;
            }
            if (this.elideSymbols) continue;
            this.processSequenceLine(string, streamParser);
        }
        throw new IOException("Premature end of stream for EMBL");
    }

    public void setElideSymbols(boolean bl) {
        this.elideSymbols = bl;
    }

    public void writeSequence(Sequence sequence, PrintStream printStream) throws IOException {
        try {
            String string = this.getDefaultFormat();
            SeqFileFormer seqFileFormer = SeqFileFormerFactory.makeFormer(string);
            SeqIOEventEmitter.getSeqIOEvents(sequence, seqFileFormer);
        }
        catch (BioException bioException) {
            bioException.printStackTrace();
        }
    }

    public void writeSequence(Sequence sequence, String string, PrintStream printStream) throws IOException {
        String string2 = new String(string);
        boolean bl = false;
        try {
            String[] stringArray = this.getFormats().toArray(new String[0]);
            int n = 0;
            while (n < stringArray.length) {
                if (stringArray[n].equalsIgnoreCase(string)) {
                    string2 = stringArray[n];
                    bl = true;
                }
                ++n;
            }
            if (!bl) {
                throw new BioException("An invalid file format '" + string + "' was requested");
            }
            SeqFileFormer seqFileFormer = SeqFileFormerFactory.makeFormer(string2);
            seqFileFormer.setPrintStream(printStream);
            SeqIOEventEmitter.getSeqIOEvents(sequence, seqFileFormer);
        }
        catch (BioException bioException) {
            bioException.printStackTrace();
        }
    }
}

