/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.seq.impl;

import java.util.Iterator;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioException;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;

public class ProjectedFeatureWrapper
implements Feature {
    private transient ChangeSupport changeSupport;
    private final Feature feature;
    private final ProjectedFeatureHolder holder;
    private final Location newLocation;
    private FeatureHolder projectedFeatures;

    public ProjectedFeatureWrapper(Feature feature, ProjectedFeatureHolder projectedFeatureHolder) {
        this.feature = feature;
        this.holder = projectedFeatureHolder;
        this.newLocation = projectedFeatureHolder.getProjectedLocation(feature.getLocation());
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.instantiateChangeSupport();
        this.getChangeSupport().addChangeListener(changeListener);
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        this.instantiateChangeSupport();
        this.getChangeSupport().addChangeListener(changeListener, changeType);
    }

    public boolean containsFeature(Feature feature) {
        if (this.countFeatures() > 0) {
            return this.getProjectedFeatures().containsFeature(feature);
        }
        return false;
    }

    public int countFeatures() {
        return this.feature.countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws BioException {
        throw new BioException("Can't create subfeatures of projected features");
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        FeatureFilter.ContainedByLocation containedByLocation = new FeatureFilter.ContainedByLocation(this.newLocation);
        if (FilterUtils.areDisjoint(featureFilter, containedByLocation)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(featureFilter, bl);
    }

    public Annotation getAnnotation() {
        return this.feature.getAnnotation();
    }

    protected ChangeSupport getChangeSupport() {
        return this.changeSupport;
    }

    public Feature getFeature() {
        return this.feature;
    }

    public Location getLocation() {
        return this.newLocation;
    }

    public FeatureHolder getParent() {
        return this.holder.getParent();
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            this.projectedFeatures = new ProjectedFeatureHolder(this.feature, this, this.holder.getTranslation(), this.holder.isOppositeStrand());
        }
        return this.projectedFeatures;
    }

    protected ProjectedFeatureHolder getProjectingFeatureHolder() {
        return this.holder;
    }

    public Sequence getSequence() {
        FeatureHolder featureHolder = this.getParent();
        while (featureHolder instanceof Feature) {
            featureHolder = ((Feature)featureHolder).getParent();
        }
        return (Sequence)featureHolder;
    }

    public String getSource() {
        return this.feature.getSource();
    }

    public SymbolList getSymbols() {
        return this.feature.getSymbols();
    }

    public String getType() {
        return this.feature.getType();
    }

    public Feature getViewedFeature() {
        return this.feature;
    }

    protected void instantiateChangeSupport() {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
    }

    public Feature.Template makeTemplate() {
        return this.getFeature().makeTemplate();
    }

    public void removeChangeListener(ChangeListener changeListener) {
        ChangeSupport changeSupport = this.getChangeSupport();
        if (changeSupport != null) {
            changeSupport.removeChangeListener(changeListener);
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        ChangeSupport changeSupport = this.getChangeSupport();
        if (changeSupport != null) {
            changeSupport.removeChangeListener(changeListener, changeType);
        }
    }

    public void removeFeature(Feature feature) {
        throw new UnsupportedOperationException("Projected features don't have children (yet).");
    }
}

