/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.SimpleAnnotation;
import org.biojava.bio.program.das.FeatureRequestManager;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.RealizingFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.SimpleFeatureHolder;
import org.biojava.bio.seq.io.ParseException;
import org.biojava.bio.seq.io.SeqIOAdapter;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;

class DASFeatureSet
implements FeatureHolder {
    private FeatureRequestManager.Ticket featureTicket;
    private SimpleFeatureHolder realFeatures;
    private Sequence refSequence;
    private URL dataSource;
    private String sourceID;
    private String dataSourceString;

    DASFeatureSet(Sequence sequence, URL uRL, String string) throws BioException {
        this.refSequence = sequence;
        this.dataSource = uRL;
        this.sourceID = string;
        this.dataSourceString = this.dataSource.toString();
    }

    static /* synthetic */ SimpleFeatureHolder access$0(DASFeatureSet dASFeatureSet) {
        return dASFeatureSet.realFeatures;
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public boolean containsFeature(Feature feature) {
        return this.getFeatures().containsFeature(feature);
    }

    public int countFeatures() {
        return this.getFeatures().countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws ChangeVetoException {
        throw new ChangeVetoException("Can't create features on DAS sequences.");
    }

    public Iterator features() {
        return this.getFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        return this.getFeatures().filter(featureFilter, bl);
    }

    protected FeatureHolder getFeatures() {
        if (this.realFeatures != null) {
            return this.realFeatures;
        }
        try {
            this.registerFeatureFetcher();
            this.featureTicket.doFetch();
        }
        catch (ParseException parseException) {
            throw new BioError(parseException, "Error parsing feature table");
        }
        catch (BioException bioException) {
            throw new BioError(bioException);
        }
        if (this.realFeatures == null) {
            throw new BioError("Assertion failure: features didn't get fetched.");
        }
        return this.realFeatures;
    }

    void registerFeatureFetcher() {
        if (this.featureTicket == null) {
            DASFeatureSetPopulator dASFeatureSetPopulator = new DASFeatureSetPopulator();
            FeatureRequestManager featureRequestManager = FeatureRequestManager.getManager(this.dataSource);
            this.featureTicket = featureRequestManager.requestFeatures(this.sourceID, dASFeatureSetPopulator);
        }
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) throws ChangeVetoException {
        throw new ChangeVetoException("Can't remove features from DAS sequences.");
    }

    private class DASFeatureSetPopulator
    extends SeqIOAdapter {
        private SimpleFeatureHolder holder;
        private List featureStack = new ArrayList();
        private Feature stackTop = null;

        DASFeatureSetPopulator() {
        }

        public void endFeature() throws ParseException {
            if (this.featureStack.size() < 1) {
                throw new BioError("Missmatched endFeature()");
            }
            this.featureStack.remove(this.featureStack.size() - 1);
            int n = this.featureStack.size() - 1;
            this.stackTop = null;
            while (this.stackTop == null && n >= 0) {
                this.stackTop = (Feature)this.featureStack.get(n--);
            }
        }

        public void endSequence() {
            DASFeatureSet.this.realFeatures = this.holder;
        }

        public void startFeature(Feature.Template template) throws ParseException {
            if (template instanceof ComponentFeature.Template) {
                this.featureStack.add(null);
            } else {
                try {
                    Feature feature = null;
                    if (template.annotation == Annotation.EMPTY_ANNOTATION) {
                        template.annotation = new SimpleAnnotation();
                    }
                    template.annotation.setProperty("org.biojava.bio.program.das.annotation_server", DASFeatureSet.this.dataSource);
                    if (this.stackTop == null) {
                        feature = ((RealizingFeatureHolder)((Object)DASFeatureSet.this.refSequence)).realizeFeature(DASFeatureSet.this.refSequence, template);
                        this.holder.addFeature(feature);
                    } else {
                        feature = this.stackTop.createFeature(template);
                    }
                    this.featureStack.add(feature);
                    this.stackTop = feature;
                }
                catch (Exception exception) {
                    throw new ParseException(exception, "Couldn't realize feature in DAS");
                }
            }
        }

        public void startSequence() {
            this.holder = new SimpleFeatureHolder();
        }
    }
}

