/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.dp;

import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.biojava.bio.Annotation;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dp.EmissionState;
import org.biojava.bio.dp.ModelTrainer;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.SingletonAlphabet;
import org.biojava.utils.ChangeEvent;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeSupport;
import org.biojava.utils.ChangeType;
import org.biojava.utils.ChangeVetoException;
import org.biojava.utils.SingletonList;

public class SimpleEmissionState
implements EmissionState,
Serializable {
    private Distribution dis;
    private String name;
    private Annotation ann;
    private int[] advance;
    private Alphabet matches;
    private transient ChangeSupport changeSupport = null;

    public SimpleEmissionState(String string, Annotation annotation, int[] nArray, Distribution distribution) {
        this.name = string;
        this.ann = annotation;
        this.advance = nArray;
        this.dis = distribution;
        this.matches = new SingletonAlphabet(this);
    }

    public void addChangeListener(ChangeListener changeListener) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener);
        }
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport == null) {
            this.changeSupport = new ChangeSupport();
        }
        ChangeSupport changeSupport = this.changeSupport;
        synchronized (changeSupport) {
            this.changeSupport.addChangeListener(changeListener, changeType);
        }
    }

    public int[] getAdvance() {
        return this.advance;
    }

    public final Annotation getAnnotation() {
        return this.ann;
    }

    public Set getBases() {
        return Collections.singleton(this);
    }

    public final Distribution getDistribution() {
        return this.dis;
    }

    public Alphabet getMatches() {
        return this.matches;
    }

    public final String getName() {
        return this.name;
    }

    public List getSymbols() {
        return new SingletonList(this);
    }

    public char getToken() {
        return this.name.charAt(0);
    }

    public void registerWithTrainer(ModelTrainer modelTrainer) {
        modelTrainer.registerDistribution(this.getDistribution());
    }

    public void removeChangeListener(ChangeListener changeListener) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener);
            }
        }
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
        if (this.changeSupport != null) {
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.removeChangeListener(changeListener, changeType);
            }
        }
    }

    public void setAdvance(int[] nArray) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.advance = nArray;
        } else {
            ChangeEvent changeEvent = new ChangeEvent(this, EmissionState.ADVANCE, this.advance, nArray);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.advance = nArray;
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public final void setAnnotation(Annotation annotation) {
        this.ann = annotation;
    }

    public final void setDistribution(Distribution distribution) throws ChangeVetoException {
        if (this.changeSupport == null) {
            this.dis = distribution;
        } else {
            ChangeEvent changeEvent = new ChangeEvent(this, EmissionState.DISTRIBUTION, this.dis, distribution);
            ChangeSupport changeSupport = this.changeSupport;
            synchronized (changeSupport) {
                this.changeSupport.firePreChangeEvent(changeEvent);
                this.dis = distribution;
                this.changeSupport.firePostChangeEvent(changeEvent);
            }
        }
    }

    public final void setName(String string) {
        this.name = string;
    }
}

