/*
 * Decompiled with CFR 0.152.
 */
package org.acedb;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.acedb.AceException;
import org.acedb.AceSet;
import org.acedb.AceURL;
import org.acedb.AceUtils;
import org.acedb.Connection;
import org.acedb.Database;
import org.acedb.Driver;

public class Ace {
    private static Set drivers = new HashSet();
    private static Map databases = new HashMap();

    static {
        Properties properties = System.getProperties();
        String string = (String)((Hashtable)properties).get("java.protocol.handler.pkgs");
        String string2 = "org";
        string = string != null ? String.valueOf(string) + "|" + string2 : string2;
        ((Hashtable)properties).put("java.protocol.handler.pkgs", string);
    }

    private Ace() {
    }

    public static AceSet fetch(AceURL aceURL) throws AceException {
        Database database = Ace.getDatabase(aceURL);
        if (database == null) {
            throw new NullPointerException("getDatabase(" + aceURL + ") returned null");
        }
        return database.fetch(aceURL);
    }

    public static Connection getConnection(AceURL aceURL) throws AceException {
        Database database = Ace.getDatabase(aceURL);
        return database.getConnection();
    }

    static Database getDatabase(AceURL aceURL) throws AceException {
        Database database;
        block3: {
            database = (Database)databases.get(aceURL = AceUtils.rootURL(aceURL));
            if (database == null) {
                Iterator iterator = drivers.iterator();
                while (iterator.hasNext()) {
                    Driver driver = (Driver)iterator.next();
                    if (!driver.accept(aceURL)) continue;
                    database = driver.connect(aceURL);
                    if (database == null) {
                        throw new NullPointerException("Driver returned null when connecting to URL " + aceURL);
                    }
                    databases.put(aceURL, database);
                    break block3;
                }
                throw new NullPointerException("Couldn't find driver for URL " + aceURL);
            }
        }
        return database;
    }

    public static void registerDriver(Driver driver) {
        drivers.add(driver);
    }
}

