/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.BasisFunctionWithHistory;
import eponine.model.BundleConstraint;
import eponine.model.ConstraintBasisFunction;
import eponine.model.ModelTools;
import eponine.model.PositionedConstraint;
import eponine.model.WeightMatrixConstraint;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.dist.OrderNDistribution;
import org.biojava.bio.dist.SimpleDistributionTrainerContext;
import org.biojava.bio.dp.SimpleWeightMatrix;
import org.biojava.bio.dp.WeightMatrix;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.FundamentalAtomicSymbol;
import org.biojava.bio.symbol.Symbol;
import stats.glm.BasisFunction;
import stats.glm.BasisSource;
import stats.glm.SLMTrainingContext;

public class SampleWMBasisSource
extends FundamentalAtomicSymbol
implements BasisSource {
    private double nullModelWeighting = 3.0;
    private int sampleCounts = 71;
    private double nullModelWeightingN = 3.0;
    private double nullModelPerMarginalColumn = 0.0;
    private int sampleCountsN = 71;
    private String name = "samplewm";

    public SampleWMBasisSource() {
        super("samplewm", ' ', Annotation.EMPTY_ANNOTATION);
    }

    public void setNullModelWeighting(double d) {
        this.nullModelWeighting = d;
    }

    public void setSampleCounts(int n) {
        this.sampleCounts = n;
    }

    public void setNullModelWeightingN(double d) {
        this.nullModelWeightingN = d;
    }

    public void setSampleCountsN(int n) {
        this.sampleCountsN = n;
    }

    public void setNullModelPerMarginalColumn(double d) {
        this.nullModelPerMarginalColumn = d;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getName() {
        return this.name;
    }

    public BasisFunction next(SLMTrainingContext sLMTrainingContext) {
        Object object;
        Object object2;
        List list = sLMTrainingContext.getBasisList();
        HashMap<Object, Integer> hashMap = new HashMap<Object, Integer>();
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            object2 = (BasisFunction)iterator.next();
            object = ModelTools.removeHistory((BasisFunction)object2);
            if (!(object instanceof ConstraintBasisFunction)) continue;
            PositionedConstraint positionedConstraint = (PositionedConstraint)((ConstraintBasisFunction)object).getConstraint();
            int n2 = 1;
            if (positionedConstraint.getConstraint() instanceof BundleConstraint) {
                n2 = ((BundleConstraint)positionedConstraint.getConstraint()).getConstraints().size();
            }
            hashMap.put(object2, new Integer(n2));
            n += n2;
        }
        n = (int)Math.ceil((double)n * Math.random());
        object2 = hashMap.entrySet().iterator();
        while (object2.hasNext()) {
            object = (Map.Entry)object2.next();
            int n3 = (Integer)object.getValue();
            if ((n -= n3) > 0) continue;
            BasisFunction basisFunction = (BasisFunction)object.getKey();
            PositionedConstraint positionedConstraint = (PositionedConstraint)ModelTools.getConstraint(basisFunction);
            if (n3 == 1) {
                WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint.getConstraint();
                weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
                return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(weightMatrixConstraint, positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
            }
            ArrayList<PositionedConstraint> arrayList = new ArrayList<PositionedConstraint>(((BundleConstraint)positionedConstraint.getConstraint()).getConstraints());
            PositionedConstraint positionedConstraint2 = (PositionedConstraint)arrayList.get(-n);
            WeightMatrixConstraint weightMatrixConstraint = (WeightMatrixConstraint)positionedConstraint2.getConstraint();
            weightMatrixConstraint = this.sampleWeightMatrixConstraint(weightMatrixConstraint);
            arrayList.set(-n, new PositionedConstraint(weightMatrixConstraint, positionedConstraint2.getPosition(), positionedConstraint2.getDistribution(), positionedConstraint2.isMaximum()));
            return new BasisFunctionWithHistory(new ConstraintBasisFunction(new PositionedConstraint(new BundleConstraint(arrayList), positionedConstraint.getPosition(), positionedConstraint.getDistribution(), positionedConstraint.isMaximum())), Collections.singleton(basisFunction), this, sLMTrainingContext.getCurrentCycle());
        }
        System.out.println("totalProb exceeded");
        return null;
    }

    private WeightMatrixConstraint sampleWeightMatrixConstraint(WeightMatrixConstraint weightMatrixConstraint) {
        try {
            WeightMatrix weightMatrix = weightMatrixConstraint.getWeightMatrix();
            if (weightMatrix.getAlphabet().getAlphabets().size() > 1) {
                return new WeightMatrixConstraint(this.sampleWeightMatrixN(weightMatrix), 0.0);
            }
            return new WeightMatrixConstraint(this.sampleWeightMatrix1(weightMatrix), weightMatrixConstraint.getReversibility());
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    private WeightMatrix sampleWeightMatrix1(WeightMatrix weightMatrix) {
        try {
            SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(weightMatrix.getAlphabet(), weightMatrix.columns(), ModelTools.DIST_FACTORY);
            SimpleDistributionTrainerContext simpleDistributionTrainerContext = new SimpleDistributionTrainerContext();
            simpleDistributionTrainerContext.setNullModelWeight(this.nullModelWeighting + this.nullModelPerMarginalColumn * (double)weightMatrix.columns());
            int n = this.sampleCounts;
            int n2 = 0;
            while (n2 < simpleWeightMatrix.columns()) {
                simpleDistributionTrainerContext.registerDistribution(simpleWeightMatrix.getColumn(n2));
                ++n2;
            }
            int n3 = 0;
            while (n3 < simpleWeightMatrix.columns()) {
                Distribution distribution = weightMatrix.getColumn(n3);
                Distribution distribution2 = simpleWeightMatrix.getColumn(n3);
                int n4 = 0;
                while (n4 < n) {
                    simpleDistributionTrainerContext.addCount(distribution2, distribution.sampleSymbol(), 1.0);
                    ++n4;
                }
                ++n3;
            }
            simpleDistributionTrainerContext.train();
            return simpleWeightMatrix;
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    private WeightMatrix sampleWeightMatrixN(WeightMatrix weightMatrix) {
        try {
            Object object;
            SimpleWeightMatrix simpleWeightMatrix = new SimpleWeightMatrix(weightMatrix.getAlphabet(), weightMatrix.columns(), ModelTools.DIST_FACTORY);
            SimpleDistributionTrainerContext simpleDistributionTrainerContext = new SimpleDistributionTrainerContext();
            simpleDistributionTrainerContext.setNullModelWeight(this.nullModelWeightingN);
            int n = this.sampleCountsN;
            int n2 = 0;
            while (n2 < simpleWeightMatrix.columns()) {
                OrderNDistribution orderNDistribution = (OrderNDistribution)simpleWeightMatrix.getColumn(n2);
                object = ((FiniteAlphabet)orderNDistribution.getConditioningAlphabet()).iterator();
                while (object.hasNext()) {
                    simpleDistributionTrainerContext.registerDistribution(orderNDistribution.getDistribution((Symbol)object.next()));
                }
                ++n2;
            }
            int n3 = 0;
            while (n3 < simpleWeightMatrix.columns()) {
                object = (OrderNDistribution)weightMatrix.getColumn(n3);
                OrderNDistribution orderNDistribution = (OrderNDistribution)simpleWeightMatrix.getColumn(n3);
                Iterator iterator = ((FiniteAlphabet)object.getConditioningAlphabet()).iterator();
                while (iterator.hasNext()) {
                    Symbol symbol = (Symbol)iterator.next();
                    Distribution distribution = object.getDistribution(symbol);
                    Distribution distribution2 = orderNDistribution.getDistribution(symbol);
                    int n4 = 0;
                    while (n4 < n) {
                        simpleDistributionTrainerContext.addCount(distribution2, distribution.sampleSymbol(), 1.0);
                        ++n4;
                    }
                }
                ++n3;
            }
            simpleDistributionTrainerContext.train();
            return simpleWeightMatrix;
        }
        catch (Exception exception) {
            throw new BioError(exception);
        }
    }

    public boolean hasNext(SLMTrainingContext sLMTrainingContext) {
        return sLMTrainingContext.getCurrentCycle() > 0 && sLMTrainingContext.getBasisList().size() >= 3;
    }
}

