/*
 * Decompiled with CFR 0.152.
 */
package eponine.model;

import eponine.model.Constraint;
import eponine.model.DiscreteDistribution;
import java.io.Serializable;
import org.biojava.bio.symbol.SymbolList;

public class PositionedConstraint
implements Constraint,
Serializable {
    private Constraint constraint;
    private int position;
    private DiscreteDistribution dist;
    private boolean maximize;

    public PositionedConstraint(Constraint constraint, int n, DiscreteDistribution discreteDistribution, boolean bl) {
        this.constraint = constraint;
        this.position = n;
        this.dist = discreteDistribution;
        this.maximize = bl;
    }

    public Constraint getConstraint() {
        return this.constraint;
    }

    public int getPosition() {
        return this.position;
    }

    public DiscreteDistribution getDistribution() {
        return this.dist;
    }

    public boolean isMaximum() {
        return this.maximize;
    }

    public int hashCode() {
        return this.constraint.hashCode() + this.position * 10000 + this.dist.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof PositionedConstraint)) {
            return false;
        }
        PositionedConstraint positionedConstraint = (PositionedConstraint)object;
        if (positionedConstraint.getPosition() != this.position) {
            return false;
        }
        if (!positionedConstraint.getDistribution().equals(this.dist)) {
            return false;
        }
        return positionedConstraint.getConstraint().equals(this.constraint);
    }

    public double evaluate(SymbolList symbolList, int n) {
        double d = 0.0;
        int n2 = this.dist.getMin();
        while (n2 <= this.dist.getMax()) {
            double d2;
            double d3 = this.constraint.evaluate(symbolList, n + this.position + n2);
            if (this.maximize) {
                d2 = d3 * this.dist.probabilityDivMax(n2);
                d = Math.max(d, d2);
            } else {
                d2 = d3 * this.dist.probability(n2);
                d += d2;
            }
            ++n2;
        }
        return d;
    }

    public double nullModel(SymbolList symbolList, int n) {
        return this.constraint.nullModel(symbolList, n + this.position);
    }

    public double divisor() {
        return this.constraint.divisor();
    }
}

