## ----include = FALSE----------------------------------------------------------
knitr::opts_chunk$set(
    collapse = TRUE,
    comment = "#>"
)

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("BiocManager", quietly = TRUE)) {
#     install.packages("BiocManager")
# }
# BiocManager::install("faers")

## ----eval=FALSE---------------------------------------------------------------
# if (!requireNamespace("pak")) {
#     install.packages("pak",
#         repos = sprintf(
#             "https://r-lib.github.io/p/pak/devel/%s/%s/%s",
#             .Platform$pkgType, R.Version()$os, R.Version()$arch
#         )
#     )
# }
# pak::pkg_install("Yunuuuu/faers")

## ----setup--------------------------------------------------------------------
library(faers)

## ----eval=FALSE---------------------------------------------------------------
# faers_meta()

## -----------------------------------------------------------------------------
faers_meta(internal = TRUE)

## -----------------------------------------------------------------------------
# Please make sure to replace dir with your own directory path, as the file
# included in the package is a sampled version. 
data1 <- faers(2004, "q1",
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
data1

## -----------------------------------------------------------------------------
data2 <- faers(c(2004, 2017), c("q1", "q2"),
    dir = system.file("extdata", package = "faers"),
    compress_dir = tempdir()
)
data2

## -----------------------------------------------------------------------------
faers_get(data2, "demo")

## ----eval=FALSE---------------------------------------------------------------
# # you must replace `meddra_path` with the path of uncompressed meddra data
# data <- faers_standardize(data2, meddra_path)

## -----------------------------------------------------------------------------
data <- readRDS(system.file("extdata", "standardized_data.rds",
    package = "faers"
))
data

## -----------------------------------------------------------------------------
faers_meddra(data)
faers_meddra(data, use = "hierarchy")

## -----------------------------------------------------------------------------
faers_get(data, "indi")

## -----------------------------------------------------------------------------
faers_get(data, "reac")

## -----------------------------------------------------------------------------
data <- faers_dedup(data)
data

## -----------------------------------------------------------------------------
insulin_names <- "insulin"
insulin_pattern <- paste(insulin_names, collapse = "|")
fda_insulin <- fda_drugs()[
    grepl(insulin_pattern, ActiveIngredient, ignore.case = TRUE)
]
insulin_pattern <- paste0(
    unique(tolower(c(insulin_names, fda_insulin$DrugName))),
    collapse = "|"
)
insulin_data <- faers_filter(data, .fn = function(x) {
    idx <- grepl(insulin_pattern, x$drugname, ignore.case = TRUE) |
        grepl(insulin_pattern, x$prod_ai, ignore.case = TRUE)
    x[idx, primaryid]
}, .field = "drug")
insulin_data

## ----warning=FALSE------------------------------------------------------------
insulin_signals <- faers_phv_signal(insulin_data,
    .full = data,
    BPPARAM = BiocParallel::SerialParam(RNGseed = 1L)
)
insulin_signals

## ----warning=FALSE------------------------------------------------------------
insulin_signals_hlgt <- faers_phv_signal(
    insulin_data,
    .events = "hlgt_name", .full = data,
    BPPARAM = BiocParallel::SerialParam(RNGseed = 1L)
)
insulin_signals_hlgt

## -----------------------------------------------------------------------------
sessionInfo()

