/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.iapi.services.loader;

import org.apache.derby.iapi.services.context.ContextImpl;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.services.loader.ClassFactory;
import org.apache.derby.iapi.services.loader.JarReader;
import org.apache.derby.iapi.services.locks.CompatibilitySpace;
import org.apache.derby.iapi.services.property.PersistentSet;
import org.apache.derby.shared.common.error.StandardException;

public abstract class ClassFactoryContext
extends ContextImpl {
    public static final String CONTEXT_ID = "ClassFactoryContext";
    private final ClassFactory cf;

    protected ClassFactoryContext(ContextManager contextManager, ClassFactory classFactory) {
        super(contextManager, CONTEXT_ID);
        this.cf = classFactory;
    }

    public final ClassFactory getClassFactory() {
        return this.cf;
    }

    public abstract CompatibilitySpace getLockSpace() throws StandardException;

    public abstract PersistentSet getPersistentSet() throws StandardException;

    public abstract JarReader getJarReader();

    @Override
    public final void cleanupOnError(Throwable throwable) {
        StandardException standardException;
        if (throwable instanceof StandardException && (standardException = (StandardException)throwable).getSeverity() >= 40000) {
            this.popMe();
        }
    }
}

