/*
 * Decompiled with CFR 0.152.
 */
package org.bridgedb.rdb;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.bridgedb.BridgeDb;
import org.bridgedb.DataSource;
import org.bridgedb.IDMapper;
import org.bridgedb.IDMapperException;
import org.bridgedb.IDMapperStack;
import org.bridgedb.bio.Organism;
import org.bridgedb.rdb.IDMapperRdb;
import org.bridgedb.rdb.impl.ConfigFile;

public class GdbProvider {
    Map<Organism, IDMapperStack> organism2gdb = new HashMap<Organism, IDMapperStack>();
    List<IDMapper> globalGdbs = new ArrayList<IDMapper>();
    static final String DB_GLOBAL = "*";
    private final boolean transitive;

    public Set<Organism> getOrganisms() {
        return this.organism2gdb.keySet();
    }

    public void addOrganismGdb(Organism organism, IDMapper gdb) {
        IDMapperStack l = this.organism2gdb.get(organism);
        if (l == null) {
            l = new IDMapperStack();
            this.organism2gdb.put(organism, l);
            l.setTransitive(this.transitive);
            for (IDMapper globalGdb : this.globalGdbs) {
                l.addIDMapper(globalGdb);
            }
        }
        l.addIDMapper(gdb);
    }

    public void removeOrganismGdb(Organism organism, IDMapperRdb gdb) {
        IDMapperStack l = this.organism2gdb.get(organism);
        if (l != null) {
            l.removeIDMapper((IDMapper)gdb);
        }
    }

    public void addGlobalGdb(IDMapper gdb) {
        if (!this.globalGdbs.contains(gdb)) {
            this.globalGdbs.add(gdb);
            for (Organism org : this.organism2gdb.keySet()) {
                this.organism2gdb.get(org).addIDMapper(gdb);
            }
        }
    }

    public void removeGlobalGdb(IDMapper gdb) {
        if (this.globalGdbs.contains(gdb)) {
            this.globalGdbs.remove(gdb);
            for (Organism org : this.organism2gdb.keySet()) {
                this.organism2gdb.get(org).removeIDMapper(gdb);
            }
        }
    }

    public List<IDMapper> getGdbs(Organism organism) {
        return this.getStack(organism).getMappers();
    }

    public IDMapperStack getStack(Organism organism) {
        IDMapperStack gdbs = this.organism2gdb.get(organism);
        if (gdbs == null) {
            gdbs = new IDMapperStack();
            gdbs.setTransitive(this.transitive);
            for (IDMapper globalGdb : this.globalGdbs) {
                gdbs.addIDMapper(globalGdb);
            }
        }
        return gdbs;
    }

    public GdbProvider() {
        this(false);
    }

    public GdbProvider(boolean transitive) {
        this.transitive = transitive;
    }

    public static GdbProvider fromConfigFile(File f) throws IDMapperException, IOException, ClassNotFoundException {
        return GdbProvider.fromConfigFile(f, false);
    }

    public static GdbProvider fromConfigFile(File f, boolean transitive) throws IDMapperException, IOException, ClassNotFoundException {
        ConfigFile cf = new ConfigFile(f);
        GdbProvider gdbs = new GdbProvider(transitive);
        List<String> drivers = cf.getDrivers();
        Set dsSet = new HashSet();
        dsSet = DataSource.getDataSources();
        if (dsSet.size() <= 5) {
            throw new IDMapperException("Insufficient data sources loaded. Please ensure datasources.tsv is loaded by invoking DataSourceTxt.init() before invoking the GdbProvider.fromConfigFile() method.");
        }
        drivers.add("org.bridgedb.rdb.IDMapperRdb");
        drivers.add("org.bridgedb.file.IDMapperText");
        drivers.add("com.mysql.jdbc.Driver");
        for (String driver : drivers) {
            try {
                Class.forName(driver);
                System.out.println("Loaded driver: " + driver);
            }
            catch (ClassNotFoundException ex) {
                System.out.println("Warning: driver '" + driver + "'  not in classpath, some features may not be available.");
            }
        }
        for (String key : cf.getMappers().keySet()) {
            for (String value : cf.getMappers().get(key)) {
                IDMapper mapper = BridgeDb.connect((String)value);
                Organism org = Organism.fromLatinName((String)key);
                if (org != null) {
                    gdbs.addOrganismGdb(org, mapper);
                    continue;
                }
                if (DB_GLOBAL.equalsIgnoreCase(key)) {
                    gdbs.addGlobalGdb(mapper);
                    continue;
                }
                System.out.println("Unable to parse organism: " + key);
            }
        }
        return gdbs;
    }
}

