/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.symbol;

import java.io.Serializable;
import java.util.Iterator;
import java.util.List;
import org.biojava.bio.symbol.AbstractSymbolList;
import org.biojava.bio.symbol.Alphabet;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;

public class SimpleSymbolList
extends AbstractSymbolList
implements Serializable {
    private static final int INCREMENT = 100;
    private Alphabet alphabet;
    private Symbol[] symbols;
    private int length;

    public SimpleSymbolList(Alphabet alphabet) {
        this.alphabet = alphabet;
        this.length = 0;
        this.symbols = new Symbol[100];
        this.addListener();
    }

    public SimpleSymbolList(Alphabet alphabet, List list) throws IllegalSymbolException {
        this.alphabet = alphabet;
        this.length = list.size();
        this.symbols = new Symbol[this.length];
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            this.symbols[n] = (Symbol)iterator.next();
            this.alphabet.validate(this.symbols[n]);
            ++n;
        }
        this.addListener();
    }

    public SimpleSymbolList(SymbolList symbolList) {
        this.alphabet = symbolList.getAlphabet();
        this.length = symbolList.length();
        this.symbols = new Symbol[this.length];
        int n = 0;
        while (n < this.length) {
            this.symbols[n] = symbolList.symbolAt(n + 1);
            ++n;
        }
        this.addListener();
    }

    private void addListener() {
        this.alphabet.addChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public void addSymbol(Symbol symbol) throws IllegalSymbolException {
        this.alphabet.validate(symbol);
        if (this.symbols.length <= this.length) {
            Symbol[] symbolArray = new Symbol[this.symbols.length + 100];
            System.arraycopy(this.symbols, 0, symbolArray, 0, this.length);
            this.symbols = symbolArray;
        }
        this.symbols[this.length++] = symbol;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.alphabet.removeChangeListener(ChangeListener.ALWAYS_VETO, Alphabet.SYMBOLS);
    }

    public Alphabet getAlphabet() {
        return this.alphabet;
    }

    public int length() {
        return this.length;
    }

    public Symbol symbolAt(int n) {
        if (n > this.length || n < 1) {
            throw new IndexOutOfBoundsException("Can't access " + n + " as it is not within 1.." + this.length);
        }
        return this.symbols[n - 1];
    }
}

