/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.proteomics;

import java.util.HashMap;
import java.util.Iterator;
import org.biojava.bio.seq.ProteinTools;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.bio.symbol.SymbolPropertyTable;

public class MassCalc {
    public static final double Cmono = 12.0;
    public static final double Hmono = 1.007825;
    public static final double Nmono = 14.003074;
    public static final double Omono = 15.9949146;
    public static final double Cavg = 12.011;
    public static final double Havg = 1.00794;
    public static final double Navg = 14.00674;
    public static final double Oavg = 15.9994;
    private HashMap mSymbolPropertyHash;

    public MassCalc() {
    }

    public MassCalc(String string) {
        this.mSymbolPropertyHash = new HashMap();
        SymbolPropertyTable symbolPropertyTable = ProteinTools.getSymbolPropertyTable(string);
        Iterator iterator = ProteinTools.getAlphabet().symbols().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            try {
                Double d = new Double(symbolPropertyTable.getDoubleValue(symbol));
                this.mSymbolPropertyHash.put(symbol, d);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                illegalSymbolException.printStackTrace(System.err);
            }
        }
    }

    public void addSymbolModification(Symbol symbol, double d) throws IllegalSymbolException {
    }

    public static final double getMass(SymbolList symbolList, String string, boolean bl) {
        symbolList.getAlphabet().getName().equals("PROTEIN");
        double d = 0.0;
        SymbolPropertyTable symbolPropertyTable = ProteinTools.getSymbolPropertyTable(string);
        try {
            Iterator iterator = symbolList.iterator();
            while (iterator.hasNext()) {
                d += symbolPropertyTable.getDoubleValue((Symbol)iterator.next());
            }
        }
        catch (IllegalSymbolException illegalSymbolException) {
            illegalSymbolException.printStackTrace();
        }
        if (d != 0.0) {
            d = bl ? d + 3.02382 + 15.9994 : d + 2.01588 + 15.9994;
        }
        return d;
    }

    public double getMass(SymbolList symbolList, boolean bl) {
        symbolList.getAlphabet().getName().equals("PROTEIN");
        double d = 0.0;
        HashMap hashMap = this.getSymbolPropertyMap();
        Iterator iterator = symbolList.iterator();
        while (iterator.hasNext()) {
            Double d2 = (Double)hashMap.get((Symbol)iterator.next());
            d += d2.doubleValue();
        }
        if (d != 0.0) {
            d = bl ? d + 3.02382 + 15.9994 : d + 2.01588 + 15.9994;
        }
        return d;
    }

    private HashMap getSymbolPropertyMap() {
        return this.mSymbolPropertyHash;
    }

    public void setSymbolModification(char c, double d) throws IllegalSymbolException {
        Iterator iterator = ProteinTools.getAlphabet().symbols().iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            if (symbol.getToken() != c) continue;
            this.mSymbolPropertyHash.put(symbol, new Double(d));
        }
    }
}

