/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.program.das;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.biojava.bio.Annotation;
import org.biojava.bio.BioError;
import org.biojava.bio.BioException;
import org.biojava.bio.program.das.DASSequence;
import org.biojava.bio.seq.ComponentFeature;
import org.biojava.bio.seq.DNATools;
import org.biojava.bio.seq.Feature;
import org.biojava.bio.seq.FeatureFilter;
import org.biojava.bio.seq.FeatureHolder;
import org.biojava.bio.seq.FilterUtils;
import org.biojava.bio.seq.ProjectedFeatureHolder;
import org.biojava.bio.seq.Sequence;
import org.biojava.bio.seq.StrandedFeature;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.Location;
import org.biojava.bio.symbol.SymbolList;
import org.biojava.utils.ChangeListener;
import org.biojava.utils.ChangeType;

class DASComponentFeature
implements ComponentFeature {
    private final DASSequence parent;
    private FeatureHolder projectedFeatures;
    private final Location location;
    private final StrandedFeature.Strand strand;
    private final String type;
    private final String source;
    private final Annotation annotation;
    private final String componentID;
    private DASSequence componentSequence;
    private Location componentLocation;
    private final FeatureFilter membershipFilter;

    public DASComponentFeature(DASSequence dASSequence, ComponentFeature.Template template) throws BioException {
        if (this.locationContent(template.location) != this.locationContent(template.componentLocation)) {
            throw new BioException("Component and container locations must contain an equal number of symbols.");
        }
        if (!template.location.isContiguous() || !template.componentLocation.isContiguous()) {
            throw new BioException("Can only include contiguous segments in an assembly");
        }
        this.parent = dASSequence;
        this.location = template.location;
        this.componentLocation = template.componentLocation;
        this.strand = template.strand;
        this.type = template.type;
        this.source = template.source;
        this.annotation = template.annotation;
        this.membershipFilter = new FeatureFilter.ContainedByLocation(this.location);
        if (template.componentSequence != null) {
            this.componentSequence = (DASSequence)template.componentSequence;
            this.componentID = this.componentSequence.getName();
        } else {
            try {
                this.componentID = (String)template.annotation.getProperty("sequence.id");
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new BioError("No sequence.id property");
            }
        }
        if (this.strand != StrandedFeature.NEGATIVE && this.strand != StrandedFeature.POSITIVE) {
            throw new BioException("Strand must be specified when creating a ComponentFeature");
        }
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void addChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public boolean containsFeature(Feature feature) {
        return this.getProjectedFeatures().containsFeature(feature);
    }

    public int countFeatures() {
        return this.getComponentSequence().countFeatures();
    }

    public Feature createFeature(Feature.Template template) throws BioException {
        throw new BioException("Can't create features in a ComponentFeature (yet?)");
    }

    public Iterator features() {
        return this.getProjectedFeatures().features();
    }

    public FeatureHolder filter(FeatureFilter featureFilter, boolean bl) {
        Object var3_3 = null;
        if (FilterUtils.areDisjoint(featureFilter, this.membershipFilter)) {
            return FeatureHolder.EMPTY_FEATURE_HOLDER;
        }
        return this.getProjectedFeatures().filter(featureFilter, bl);
    }

    public Annotation getAnnotation() {
        return this.annotation;
    }

    public Location getComponentLocation() {
        return this.componentLocation;
    }

    public Sequence getComponentSequence() {
        if (this.componentSequence == null) {
            try {
                this.componentSequence = new DASSequence(this.parent.getParentDB(), this.parent.getDataSourceURL(), this.componentID, this.parent.dataSourceURLs());
            }
            catch (Exception exception) {
                throw new BioError(exception, "Couldn't create child DAS sequence");
            }
        }
        return this.componentSequence;
    }

    public Location getLocation() {
        return this.location;
    }

    public FeatureHolder getParent() {
        return this.parent;
    }

    protected FeatureHolder getProjectedFeatures() {
        if (this.projectedFeatures == null) {
            if (this.strand == StrandedFeature.NEGATIVE) {
                int n = this.location.getMax() + this.componentLocation.getMin();
                this.projectedFeatures = new ProjectedFeatureHolder(this.getComponentSequence(), this, n, true);
            } else if (this.strand == StrandedFeature.POSITIVE) {
                int n = this.location.getMin() - this.componentLocation.getMin();
                this.projectedFeatures = new ProjectedFeatureHolder(this.getComponentSequence(), this, n, false);
            }
        }
        return this.projectedFeatures;
    }

    public Sequence getSequence() {
        return this.parent;
    }

    DASSequence getSequenceLazy() {
        return this.componentSequence;
    }

    public String getSource() {
        return this.source;
    }

    public StrandedFeature.Strand getStrand() {
        return this.strand;
    }

    public SymbolList getSymbols() {
        SymbolList symbolList = this.componentLocation.symbols(this.getComponentSequence());
        if (this.strand == StrandedFeature.NEGATIVE) {
            try {
                symbolList = DNATools.reverseComplement(symbolList);
            }
            catch (IllegalAlphabetException illegalAlphabetException) {
                throw new BioError(illegalAlphabetException);
            }
        }
        return symbolList;
    }

    public String getType() {
        return this.type;
    }

    private int locationContent(Location location) {
        if (location.isContiguous()) {
            return location.getMax() - location.getMin() + 1;
        }
        int n = 0;
        Iterator iterator = location.blockIterator();
        while (iterator.hasNext()) {
            Location location2 = (Location)iterator.next();
            n += location2.getMax() - location2.getMin() + 1;
        }
        return n;
    }

    public Feature.Template makeTemplate() {
        throw new BioError("FIXME");
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener, ChangeType changeType) {
    }

    public void removeFeature(Feature feature) {
        throw new UnsupportedOperationException("Can't remove features from a ComponentFeature.");
    }
}

