/*
 * Decompiled with CFR 0.152.
 */
package org.biojava.bio.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Iterator;
import javax.swing.JComponent;
import org.biojava.bio.BioError;
import org.biojava.bio.dist.Distribution;
import org.biojava.bio.gui.LogoPainter;
import org.biojava.bio.gui.PlainStyle;
import org.biojava.bio.gui.SymbolStyle;
import org.biojava.bio.gui.TextLogoPainter;
import org.biojava.bio.symbol.FiniteAlphabet;
import org.biojava.bio.symbol.IllegalAlphabetException;
import org.biojava.bio.symbol.IllegalSymbolException;
import org.biojava.bio.symbol.Symbol;

public class DistributionLogo
extends JComponent {
    private static final LogoPainter DEFAULT_LOGO_PAINTER = new TextLogoPainter();
    private static double bits = Math.log(2.0);
    private Distribution dist;
    private LogoPainter logoPainter = DEFAULT_LOGO_PAINTER;
    private SymbolStyle style = new PlainStyle(Color.black, Color.gray);

    public DistributionLogo() {
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (string.equals("dist") || string.equals("logoPainter") || string.equals("style")) {
                    DistributionLogo.this.repaint();
                }
            }
        });
        Dimension dimension = new Dimension(20, 20);
        this.setMinimumSize(dimension);
        this.setPreferredSize(dimension);
    }

    public double entropy(Symbol symbol) throws IllegalSymbolException {
        Distribution distribution = this.getDistribution();
        double d = distribution.getWeight(symbol);
        double d2 = Math.log(d);
        return -d * d2 / bits;
    }

    public Distribution getDistribution() {
        return this.dist;
    }

    public LogoPainter getLogoPainter() {
        return this.logoPainter;
    }

    public SymbolStyle getStyle() {
        return this.style;
    }

    public void paintComponent(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        Rectangle rectangle = graphics2D.getClipBounds();
        if (this.isOpaque()) {
            graphics2D.clearRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        if (this.getDistribution() == null) {
            return;
        }
        this.getLogoPainter().paintLogo(graphics, this);
    }

    public void setDistribution(Distribution distribution) throws IllegalAlphabetException {
        this.firePropertyChange("dist", this.dist, distribution);
        this.dist = distribution;
    }

    public void setLogoPainter(LogoPainter logoPainter) {
        this.firePropertyChange("logoPainter", this.logoPainter, logoPainter);
        this.logoPainter = logoPainter;
    }

    public void setStyle(SymbolStyle symbolStyle) {
        this.firePropertyChange("style", this.style, symbolStyle);
        this.style = symbolStyle;
    }

    public double totalBits() {
        return Math.log(((FiniteAlphabet)this.getDistribution().getAlphabet()).size()) / bits;
    }

    public double totalInformation() {
        double d = this.totalBits();
        Distribution distribution = this.getDistribution();
        Iterator iterator = ((FiniteAlphabet)distribution.getAlphabet()).iterator();
        while (iterator.hasNext()) {
            Symbol symbol = (Symbol)iterator.next();
            try {
                d -= this.entropy(symbol);
            }
            catch (IllegalSymbolException illegalSymbolException) {
                throw new BioError(illegalSymbolException, "Symbol evaporated while calculating information");
            }
        }
        return d;
    }
}

