## ----echo=FALSE, results="hide", message=FALSE--------------------------------
knitr::opts_chunk$set(error=FALSE, message=FALSE, warning=FALSE)
library(BiocStyle)

## -----------------------------------------------------------------------------
suppressPackageStartupMessages(library(escape))
suppressPackageStartupMessages(library(SingleCellExperiment))
suppressPackageStartupMessages(library(scran))
suppressPackageStartupMessages(library(Seurat))
suppressPackageStartupMessages(library(SeuratObject))
suppressPackageStartupMessages(library(RColorBrewer))
suppressPackageStartupMessages(library(ggplot2))


pbmc_small <- get("pbmc_small")
sce.pbmc <- as.SingleCellExperiment(pbmc_small, assay = "RNA")

## ----eval=FALSE, include=FALSE------------------------------------------------
# gs <- getGeneSets(library = c("Library1", "Library2"))

## -----------------------------------------------------------------------------
GS.hallmark <- getGeneSets(library = "H")

## ----eval = FALSE-------------------------------------------------------------
# data("escape.gene.sets", package="escape")
# gene.sets <- escape.gene.sets

## ----eval=FALSE, tidy=FALSE---------------------------------------------------
# gene.sets <- list(Bcells = c("MS4A1","CD79B","CD79A","IGH1","IGH2")
# 			            Myeloid = c("SPI1","FCER1G","CSF1R"),
# 			            Tcells = c("CD3E", "CD3D", "CD3G", "CD7","CD8A"))

## ----tidy = FALSE-------------------------------------------------------------
enrichment.scores <- escape.matrix(pbmc_small, 
                                   gene.sets = GS.hallmark, 
                                   groups = 1000, 
                                   min.size = 5)

ggplot(data = as.data.frame(enrichment.scores), 
      mapping = aes(enrichment.scores[,1], enrichment.scores[,2])) + 
  geom_point() + 
  theme_classic() + 
  theme(axis.title = element_blank())

## ----tidy=FALSE, eval=FALSE---------------------------------------------------
# enrichment.scores <- escape.matrix(pbmc_small,
#                                    gene.sets = GS.hallmark,
#                                    groups = 1000,
#                                    min.size = 5,
#                                    BPPARAM = SnowParam(workers = 2))

## ----tidy = FALSE-------------------------------------------------------------
pbmc_small <- runEscape(pbmc_small, 
                        method = "ssGSEA",
                        gene.sets = GS.hallmark, 
                        groups = 1000, 
                        min.size = 5,
                        new.assay.name = "escape.ssGSEA")

sce.pbmc <- runEscape(sce.pbmc, 
                      method = "UCell",
                      gene.sets = GS.hallmark, 
                      groups = 1000, 
                      min.size = 5,
                      new.assay.name = "escape.UCell")

## ----tidy = FALSE-------------------------------------------------------------
#Define color palette 
colorblind_vector <- hcl.colors(n=7, palette = "inferno", fixup = TRUE)

FeaturePlot(pbmc_small, "HALLMARK-APOPTOSIS") + 
  scale_color_gradientn(colors = colorblind_vector) + 
  theme(plot.title = element_blank())

## -----------------------------------------------------------------------------
pbmc_small <- performNormalization(sc.data = pbmc_small, 
                                   assay = "escape.ssGSEA", 
                                   gene.sets = GS.hallmark)

## -----------------------------------------------------------------------------
pbmc_small <- performNormalization(sc.data = pbmc_small, 
                                   assay = "escape.ssGSEA", 
                                   gene.sets = GS.hallmark, 
                                   scale.factor = pbmc_small$nFeature_RNA)

## -----------------------------------------------------------------------------
heatmapEnrichment(pbmc_small, 
                  group.by = "ident",
                  gene.set.use = "all",
                  assay = "escape.ssGSEA")

## -----------------------------------------------------------------------------
heatmapEnrichment(sce.pbmc, 
                  group.by = "ident",
                  assay = "escape.UCell",
                  scale = TRUE,
                  cluster.rows = TRUE,
                  cluster.columns = TRUE)

## -----------------------------------------------------------------------------
hcl.pals()

## -----------------------------------------------------------------------------
heatmapEnrichment(pbmc_small, 
                  assay = "escape.ssGSEA",
                  palette = "Spectral") 

## -----------------------------------------------------------------------------
heatmapEnrichment(sce.pbmc, 
                  group.by = "ident",
                  assay = "escape.UCell") + 
  scale_fill_gradientn(colors = rev(brewer.pal(11, "RdYlBu"))) 

## -----------------------------------------------------------------------------
geyserEnrichment(pbmc_small, 
                 assay = "escape.ssGSEA",
                 gene.set = "HALLMARK-INTERFERON-GAMMA-RESPONSE")

## -----------------------------------------------------------------------------
geyserEnrichment(pbmc_small, 
                 assay = "escape.ssGSEA",
                 gene.set = "HALLMARK-INTERFERON-GAMMA-RESPONSE", 
                 order.by = "mean")

## -----------------------------------------------------------------------------
geyserEnrichment(pbmc_small, 
                 assay = "escape.ssGSEA",
                 gene.set = "HALLMARK-INTERFERON-GAMMA-RESPONSE", 
                 facet.by = "groups")

## -----------------------------------------------------------------------------
geyserEnrichment(pbmc_small, 
                 assay = "escape.ssGSEA",
                 gene.set = "HALLMARK-INTERFERON-GAMMA-RESPONSE", 
                 color.by  = "HALLMARK-INTERFERON-GAMMA-RESPONSE")

## -----------------------------------------------------------------------------
ridgeEnrichment(sce.pbmc, 
                assay = "escape.UCell",
                gene.set = "HALLMARK-IL2-STAT5-SIGNALING")

## -----------------------------------------------------------------------------
ridgeEnrichment(sce.pbmc, 
                assay = "escape.UCell",
                gene.set = "HALLMARK-IL2-STAT5-SIGNALING",
                add.rug = TRUE,
                scale = TRUE)

## -----------------------------------------------------------------------------
splitEnrichment(pbmc_small, 
                assay = "escape.ssGSEA",
                gene.set = "HALLMARK-IL2-STAT5-SIGNALING", 
                split.by = "groups")

## ----tidy=FALSE, eval=FALSE---------------------------------------------------
# densityEnrichment(pbmc_small,
#                   gene.set.use = "HALLMARK-IL6-JAK-STAT3-SIGNALING",
#                   gene.sets = GS.hallmark)

## -----------------------------------------------------------------------------
scatterEnrichment(pbmc_small, 
                  assay = "escape.ssGSEA",
                  x.axis = "HALLMARK-INTERFERON-GAMMA-RESPONSE",
                  y.axis = "HALLMARK-IL6-JAK-STAT3-SIGNALING")

## -----------------------------------------------------------------------------
scatterEnrichment(sce.pbmc, 
                  assay = "escape.UCell",
                  x.axis = "HALLMARK-INTERFERON-GAMMA-RESPONSE",
                  y.axis = "HALLMARK-IL6-JAK-STAT3-SIGNALING", 
                  style = "hex")

## -----------------------------------------------------------------------------
pbmc_small <- performPCA(pbmc_small, 
                         assay = "escape.ssGSEA",
                         n.dim = 1:10)

## -----------------------------------------------------------------------------
pcaEnrichment(pbmc_small, 
              dimRed = "escape.PCA",
              x.axis = "PC1",
              y.axis = "PC2")

## -----------------------------------------------------------------------------
pcaEnrichment(pbmc_small, 
              dimRed = "escape.PCA",
              x.axis = "PC1",
              y.axis = "PC2",
              add.percent.contribution = TRUE,
              display.factors = TRUE,
              number.of.factors = 10)

## -----------------------------------------------------------------------------
pbmc_small <- performNormalization(pbmc_small, 
                                   assay = "escape.ssGSEA", 
                                   gene.sets = GS.hallmark,
                                   make.positive = TRUE)

all.markers <- FindAllMarkers(pbmc_small, 
                              assay = "escape.ssGSEA_normalized", 
                              min.pct = 0,
                              logfc.threshold = 0)

head(all.markers)

## -----------------------------------------------------------------------------
sessionInfo()

