## ----setup, include=FALSE-----------------------------------------------------
knitr::opts_chunk$set(echo = TRUE)

## ----metaformat1, echo = FALSE, results = 'asis'------------------------------
library(knitr)
df <- data.frame(
    Filenam = c("p1_a12.fcs", "p2_d08.fcs", "p3_g1.fcs"), #should be the same as the GUID in the FCS files
    Plate = c("Plate1", "Plate2", "Plate3"),
    Well = c("A12", "D08", "G01"),
    Column = c("Col.12", "Col.08", "Col.01"),
    Row = c("Row.01", "Row.04", "Row.07"),
    Well.lab = c("P1_A12", "P2_D08", "P3_G01"))
kable(df)

## ----metaformat2, echo = FALSE, results = 'asis'------------------------------
library(knitr)
df <- data.frame(
    Filenam = c("090122.fcs", "070122.fcs", "010122.fcs"), #should be the same as the GUID in the FCS files
    Batch = c("Batch1", "Batch2", "Batch3"))
kable(df)

## ----install_mapfx, eval=FALSE------------------------------------------------
# if (!require("BiocManager", quietly = TRUE))
#     install.packages("BiocManager")
# 
# BiocManager::install("MAPFX")

## ----dependency---------------------------------------------------------------
library(MAPFX)

## specify the package names
suppressPackageStartupMessages({
library(flowCore)
library(Biobase)
library(stringr)
library(uwot)
library(iCellR)
library(igraph)
library(ggplot2)
library(RColorBrewer)
library(Rfast)
library(ComplexHeatmap)
library(circlize)
library(glmnetUtils)
library(e1071)
library(xgboost)
library(parallel)
library(pbapply)
library(reshape2)
library(gtools)
library(utils)
library(stats)
library(cowplot)
})


## ----MapfxMPC_impu_example, eval=TRUE-----------------------------------------
# import built-in data
data(ord.fcs.raw.meta.df.out_mpc)
data(ord.fcs.raw.mt_mpc)

# create an Output directory in the current working directory for the argument 'Outpath' of the MapfxMPC function
dir.create(file.path(tempdir(), "MPC_impu_Output"))

# usage
# when impute = TRUE, randomly selecting 50% of the cells in each well for model training
set.seed(123) 
MapfxMPC_impu_obj <- MapfxMPC(
    runVignette = TRUE, #set FALSE if not running this Vignette
    runVignette_meta = ord.fcs.raw.meta.df.out_mpc, #set NULL if not running this Vignette
    runVignette_rawInten = ord.fcs.raw.mt_mpc, #set NULL if not running this Vignette
    FCSpath = NULL, # users specify their own input path
    Outpath = file.path(tempdir(), "MPC_impu_Output"), # or users specify their own output path
    file_meta = "auto",
    bkb.v = c(
    "FSC-H", "FSC-W", "SSC-H", "SSC-W", "CD69-CD301b", "MHCII", 
    "CD4", "CD44", "CD8", "CD11c", "CD11b", "F480", 
    "Ly6C", "Lineage", "CD45a488", "CD24", "CD103"),
    yvar = "Legend", 
    control.wells = c(
    "P1_A01", "P2_A01", "P3_A01",
    "P3_F04", "P3_F05", "P3_F06", "P3_F07", "P3_F08", 
    "P3_F09", "P3_F10", "P3_F11", "P3_F12",
    "P3_G01", "P3_G02"),
    bkb.upper.quantile = 0.9, 
    bkb.lower.quantile = 0.1, 
    bkb.min.quantile = 0.01,
    inf.lower.quantile = 0.1, 
    inf.min.quantile = 0.01, 
    plots.bkc.bkb = TRUE, plots.bkc.inf = TRUE, 
    plots.initM = TRUE,
    plots.rmWellEffect = TRUE,
    impute = TRUE,
    models.use = c("XGBoost"),
    extra_args_regression_params = list(list(nrounds = 1500, eta = 0.03)),
    prediction_events_downsampling = NULL,
    impu.training = FALSE,
    plots.imputation = TRUE,
    cluster.analysis.bkb = TRUE, plots.cluster.analysis.bkb = TRUE,
    cluster.analysis.all = TRUE, plots.cluster.analysis.all = TRUE,
    cores = 4L)
    
# check the details
help(MapfxMPC, package = "MAPFX")

## ----mapfxNorm_MPC, eval=FALSE------------------------------------------------
# # import built-in data
# data(ord.fcs.raw.meta.df.out_mpc)
# data(ord.fcs.raw.mt_mpc)
# 
# # create an Output directory in the current working directory for the argument 'Outpath' of the MapfxMPC function
# dir.create(file.path(tempdir(), "MPC_NOimpu_Output"))
# 
# # usage
# MapfxMPC_NOimpu_obj <- MapfxMPC(
#     runVignette = TRUE, #set FALSE if not running this Vignette
#     runVignette_meta = ord.fcs.raw.meta.df.out_mpc, #set NULL if not running this Vignette
#     runVignette_rawInten = ord.fcs.raw.mt_mpc, #set NULL if not running this Vignette
#     FCSpath = NULL, # users specify their own input path
#     Outpath = file.path(tempdir(), "MPC_NOimpu_Output"), # or users specify their own output path
#     file_meta="auto",
#     bkb.v = c(
#     "FSC-H", "FSC-W", "SSC-H", "SSC-W", "CD69-CD301b", "MHCII",
#     "CD4", "CD44", "CD8", "CD11c", "CD11b", "F480",
#     "Ly6C", "Lineage", "CD45a488", "CD24", "CD103"),
#     yvar="Legend",
#     control.wells = c(
#     "P1_A01", "P2_A01", "P3_A01",
#     "P3_F04", "P3_F05", "P3_F06", "P3_F07", "P3_F08",
#     "P3_F09", "P3_F10", "P3_F11", "P3_F12",
#     "P3_G01", "P3_G02"),
#     bkb.upper.quantile = 0.9,
#     bkb.lower.quantile = 0.1,
#     bkb.min.quantile = 0.01,
#     inf.lower.quantile = 0.1,
#     inf.min.quantile = 0.01,
#     plots.bkc.bkb = TRUE, plots.bkc.inf = TRUE,
#     plots.initM = TRUE,
#     plots.rmWellEffect = TRUE,
#     impute = FALSE,
#     cluster.analysis.bkb = TRUE, plots.cluster.analysis.bkb = TRUE,
#     cores = 4L)
# 
# # check the details
# help(MapfxMPC, package = "MAPFX")

## ----mapfxNorm_FFC, eval=TRUE-------------------------------------------------
# import built-in data
data(ord.fcs.raw.meta.df.out_ffc)
data(ord.fcs.raw.mt_ffc)

# create an Output directory in the current working directory for the argument 'Outpath' of the MapfxFFC function
dir.create(file.path(tempdir(), "FFCnorm_Output"))

MapfxFFC_obj <- MapfxFFC(
    runVignette = TRUE, #set FALSE if not running this Vignette
    runVignette_meta = ord.fcs.raw.meta.df.out_ffc, #set NULL if not running this Vignette
    runVignette_rawInten = ord.fcs.raw.mt_ffc, #set NULL if not running this Vignette
    FCSpath = NULL, # users specify their own input path
    Outpath = file.path(tempdir(), "FFCnorm_Output"), # or users specify their own output path
    protein.v = c("CD3","CD4","CD8","CD45"),
    protein.upper.quantile = 0.9, 
    protein.lower.quantile = 0.1, 
    protein.min.quantile = 0.01,
    plots.bkc.protein = TRUE,
    plots.initM = TRUE,
    plots.rmBatchEffect = TRUE,
    cluster.analysis.protein = TRUE, plots.cluster.analysis.protein = TRUE)
    
# check the details
help(MapfxFFC, package = "MAPFX")

## ----sessinfo-----------------------------------------------------------------
sessionInfo()

