/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model;

import java.util.List;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.gradle.api.Project;
import org.gradle.api.internal.artifacts.TransformRegistration;
import org.gradle.api.internal.artifacts.VariantTransformRegistry;
import org.gradle.api.internal.artifacts.transform.Transform;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ArtifactTransformReportModel;
import org.gradle.api.tasks.diagnostics.internal.artifact.transforms.model.ReportArtifactTransform;

public abstract class ArtifactTransformReportModelFactory {
    private final VariantTransformRegistry variantTransformRegistry;

    @Inject
    public ArtifactTransformReportModelFactory(VariantTransformRegistry variantTransformRegistry) {
        this.variantTransformRegistry = variantTransformRegistry;
    }

    public ArtifactTransformReportModel buildForProject(Project project) {
        List<ReportArtifactTransform> artifactTransformData = this.variantTransformRegistry.getRegistrations().stream().map(this::convertArtifactTransform).collect(Collectors.toList());
        return new ArtifactTransformReportModel(project.getDisplayName(), artifactTransformData);
    }

    private ReportArtifactTransform convertArtifactTransform(TransformRegistration transformRegistration) {
        Transform transform = transformRegistration.getTransformStep().getTransform();
        return new ReportArtifactTransform(transform.getImplementationClass().getSimpleName(), transform.getImplementationClass(), transform.getFromAttributes(), transform.getToAttributes(), transform.isCacheable());
    }
}

