/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jgit.internal.signing.ssh;

import org.eclipse.jgit.internal.signing.ssh.OpenSshSigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.CachingSigningKeyDatabase;
import org.eclipse.jgit.signing.ssh.SigningKeyDatabase;

public final class SigningDatabase {
    private static SigningKeyDatabase INSTANCE = new OpenSshSigningKeyDatabase();

    private SigningDatabase() {
    }

    public static synchronized SigningKeyDatabase getInstance() {
        return INSTANCE;
    }

    public static synchronized SigningKeyDatabase setInstance(SigningKeyDatabase database) {
        SigningKeyDatabase previous = INSTANCE;
        if (database != INSTANCE) {
            SigningKeyDatabase signingKeyDatabase = INSTANCE;
            if (signingKeyDatabase instanceof CachingSigningKeyDatabase) {
                CachingSigningKeyDatabase caching = (CachingSigningKeyDatabase)signingKeyDatabase;
                caching.clearCache();
            }
            INSTANCE = database == null ? new OpenSshSigningKeyDatabase() : database;
        }
        return previous;
    }
}

