/*
 * Decompiled with CFR 0.152.
 */
package org.sat4j.pb;

import java.math.BigInteger;
import org.sat4j.core.VecInt;
import org.sat4j.pb.IPBSolver;
import org.sat4j.pb.PBSolverDecorator;
import org.sat4j.specs.ContradictionException;
import org.sat4j.specs.IConstr;
import org.sat4j.specs.IOptimizationProblem;
import org.sat4j.specs.IVecInt;
import org.sat4j.specs.RandomAccessModel;
import org.sat4j.specs.TimeoutException;

public class ConstraintRelaxingPseudoOptDecorator
extends PBSolverDecorator
implements IOptimizationProblem {
    private static final long serialVersionUID = 1L;
    private IConstr previousPBConstr;
    private IConstr addedConstr = null;
    private Number objectiveValue;
    private boolean optimumFound = false;

    public ConstraintRelaxingPseudoOptDecorator(IPBSolver solver) {
        super(solver);
    }

    public boolean isSatisfiable() throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY);
    }

    public boolean isSatisfiable(boolean global) throws TimeoutException {
        return this.isSatisfiable(VecInt.EMPTY, global);
    }

    public boolean isSatisfiable(IVecInt assumps, boolean global) throws TimeoutException {
        boolean result = super.isSatisfiable(assumps, true);
        if (result) {
            this.calculateObjective();
        } else if (this.previousPBConstr != null) {
            ((IPBSolver)this.decorated()).removeConstr(this.previousPBConstr);
            this.previousPBConstr = null;
        }
        return result;
    }

    public boolean isSatisfiable(IVecInt assumps) throws TimeoutException {
        return this.isSatisfiable(assumps, true);
    }

    public boolean admitABetterSolution() throws TimeoutException {
        return this.admitABetterSolution(VecInt.EMPTY);
    }

    public boolean admitABetterSolution(IVecInt assumps) throws TimeoutException {
        if (this.optimumFound) {
            return false;
        }
        int maxValue = this.getObjectiveFunction().minValue().intValue();
        while (true) {
            if (this.addedConstr != null) {
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
            }
            try {
                this.forceObjectiveValueTo(maxValue++);
            }
            catch (ContradictionException e) {
                if (!this.isVerbose()) continue;
                System.out.println(((IPBSolver)this.decorated()).getLogPrefix() + "no solution for objective value " + (maxValue - 1));
                continue;
            }
            boolean isSatisfiable = super.isSatisfiable(assumps, true);
            if (isSatisfiable) {
                this.optimumFound = true;
                if (this.getObjectiveFunction() != null) {
                    this.calculateObjective();
                }
                ((IPBSolver)this.decorated()).removeConstr(this.addedConstr);
                return true;
            }
            if (!this.isVerbose()) continue;
            System.out.println(((IPBSolver)this.decorated()).getLogPrefix() + "no solution for objective value " + (maxValue - 1));
        }
    }

    public boolean hasNoObjectiveFunction() {
        return this.getObjectiveFunction() == null;
    }

    public boolean nonOptimalMeansSatisfiable() {
        return false;
    }

    @Deprecated
    public Number calculateObjective() {
        if (this.getObjectiveFunction() == null) {
            throw new UnsupportedOperationException("The problem does not contain an objective function");
        }
        this.objectiveValue = this.getObjectiveFunction().calculateDegree((RandomAccessModel)this);
        return this.objectiveValue;
    }

    public Number getObjectiveValue() {
        return this.objectiveValue;
    }

    public void forceObjectiveValueTo(Number forcedValue) throws ContradictionException {
        this.addedConstr = super.addPseudoBoolean(this.getObjectiveFunction().getVars(), this.getObjectiveFunction().getCoeffs(), false, BigInteger.valueOf(forcedValue.longValue()));
    }

    @Deprecated
    public void discard() {
        this.discardCurrentSolution();
    }

    public void discardCurrentSolution() {
    }

    public boolean isOptimal() {
        return this.optimumFound;
    }

    public String toString(String prefix) {
        return prefix + "Pseudo Boolean Optimization by lower bound\n" + super.toString(prefix);
    }

    public void setTimeoutForFindingBetterSolution(int seconds) {
        throw new UnsupportedOperationException("Does not make sense here");
    }
}

