/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.profiler.v2.impl;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTextField;
import javax.swing.SortOrder;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import org.graalvm.visualvm.lib.profiler.LoadedSnapshot;
import org.graalvm.visualvm.lib.profiler.ProfilerTopComponent;
import org.graalvm.visualvm.lib.profiler.ResultsManager;
import org.graalvm.visualvm.lib.profiler.actions.CompareSnapshotsAction;
import org.graalvm.visualvm.lib.profiler.api.ProfilerDialogs;
import org.graalvm.visualvm.lib.profiler.api.ProfilerStorage;
import org.graalvm.visualvm.lib.profiler.api.ProjectUtilities;
import org.graalvm.visualvm.lib.profiler.api.icons.Icons;
import org.graalvm.visualvm.lib.profiler.v2.ProfilerSession;
import org.graalvm.visualvm.lib.profiler.v2.impl.Bundle;
import org.graalvm.visualvm.lib.profiler.v2.impl.SnapshotsWindowHelper;
import org.graalvm.visualvm.lib.profiler.v2.ui.ProjectSelector;
import org.graalvm.visualvm.lib.ui.UIUtils;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTable;
import org.graalvm.visualvm.lib.ui.swing.ProfilerTableContainer;
import org.graalvm.visualvm.lib.ui.swing.renderer.LabelRenderer;
import org.graalvm.visualvm.lib.ui.swing.renderer.ProfilerRenderer;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.Mode;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class SnapshotsWindowUI
extends ProfilerTopComponent {
    public static final String ID = "SnapshotsWindowUI";
    private static final HelpCtx HELP_CTX = new HelpCtx("SnapshotsWindow.HelpCtx");
    private ProfilerTable snapshotsTable;
    private ProjectSelector selector;
    private ChangeListener openProjectsListener;
    private FileObject currentFolder;
    private final List<Snapshot> snapshots = new ArrayList<Snapshot>();
    private Action openA;
    private Action exportA;
    private Action compareA;
    private Action renameA;
    private Action deleteA;
    private final AbstractTableModel snapshotsTableModel = new AbstractTableModel(){

        @Override
        public String getColumnName(int columnIndex) {
            if (columnIndex == 0) {
                return Bundle.SnapshotsWindowUI_colType();
            }
            if (columnIndex == 1) {
                return Bundle.SnapshotsWindowUI_colName();
            }
            return null;
        }

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            if (columnIndex == 0) {
                return Integer.class;
            }
            if (columnIndex == 1) {
                return Snapshot.class;
            }
            return null;
        }

        @Override
        public int getRowCount() {
            return SnapshotsWindowUI.this.snapshots.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                return ((Snapshot)SnapshotsWindowUI.this.snapshots.get(rowIndex)).getSnapshotType();
            }
            if (columnIndex == 1) {
                return SnapshotsWindowUI.this.snapshots.get(rowIndex);
            }
            return null;
        }

        @Override
        public boolean isCellEditable(int rowIndex, int columnIndex) {
            return false;
        }
    };

    public SnapshotsWindowUI() {
        this.setName(Bundle.SnapshotsWindowUI_name());
        this.setIcon(Icons.getImage((String)"ProfilerIcons.SnapshotTake"));
        this.getAccessibleContext().setAccessibleDescription(Bundle.SnapshotsWindowUI_accessDescr());
        this.putClientProperty(ID, ID);
        this.initUI();
    }

    public void refreshFolder(FileObject folder, boolean fullRefresh) {
        File f2;
        File f1 = folder == null ? null : FileUtil.toFile((FileObject)folder);
        File file = f2 = this.currentFolder == null ? null : FileUtil.toFile((FileObject)this.currentFolder);
        if (Objects.equals(f1, f2)) {
            if (fullRefresh) {
                this.refreshSnapshots();
            } else {
                this.snapshotsTableModel.fireTableDataChanged();
            }
        }
    }

    public void setProject(Lookup.Provider project) {
        this.selector.setProject(project);
    }

    public void resetProject(Lookup.Provider project) {
        this.selector.resetProject(project);
    }

    void refreshSnapshots() {
        final Lookup.Provider project = this.selector.getProject();
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                ResultsManager rm = ResultsManager.getDefault();
                final ArrayList<Snapshot> _snapshots = new ArrayList<Snapshot>();
                for (FileObject fo : rm.listSavedSnapshots(project, null)) {
                    _snapshots.add(new Snapshot(fo){

                        @Override
                        boolean alternativeSorting() {
                            return SnapshotsWindowUI.this.snapshotsTable.getSortColumn() == 0;
                        }
                    });
                }
                for (FileObject fo : rm.listSavedHeapdumps(project, null)) {
                    _snapshots.add(new Snapshot(fo){

                        @Override
                        boolean alternativeSorting() {
                            return SnapshotsWindowUI.this.snapshotsTable.getSortColumn() == 0;
                        }
                    });
                }
                FileObject __currentFolder = null;
                try {
                    __currentFolder = ProfilerStorage.getProjectFolder((Lookup.Provider)project, (boolean)false);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                final FileObject _currentFolder = __currentFolder;
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SnapshotsWindowUI.this.currentFolder = _currentFolder;
                        SnapshotsWindowUI.this.snapshots.clear();
                        SnapshotsWindowUI.this.snapshots.addAll(_snapshots);
                        SnapshotsWindowUI.this.snapshotsTableModel.fireTableDataChanged();
                    }
                });
            }
        });
    }

    private void initUI() {
        JPanel contents = new JPanel(new GridBagLayout());
        contents.setOpaque(true);
        contents.setBackground(UIUtils.getProfilerResultsBackground());
        int y = 0;
        JLabel projectSelectL = new JLabel(Bundle.SnapshotsWindowUI_lblProject(), 10);
        GridBagConstraints c = new GridBagConstraints();
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(10, 10, 0, 10);
        contents.add((Component)projectSelectL, c);
        ProjectSelector.Populator populator = new ProjectSelector.Populator(){

            @Override
            protected Lookup.Provider initialProject() {
                ProfilerSession ps = ProfilerSession.currentSession();
                return ps == null ? ProjectUtilities.getMainProject() : ps.getProject();
            }

            @Override
            protected Collection<Lookup.Provider> additionalProjects() {
                Lookup.Provider cp;
                ProfilerSession ps = ProfilerSession.currentSession();
                Lookup.Provider provider = cp = ps == null ? null : ps.getProject();
                if (cp != null) {
                    return Collections.singleton(cp);
                }
                return super.additionalProjects();
            }
        };
        this.selector = new ProjectSelector(populator){

            protected void selectionChanged() {
                SnapshotsWindowUI.this.refreshSnapshots();
            }
        };
        c = new GridBagConstraints();
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(3, 10, 0, 10);
        contents.add((Component)((Object)this.selector), c);
        JLabel snapshotsListL = new JLabel(Bundle.SnapshotsWindowUI_lblSnapshots(), 10);
        c = new GridBagConstraints();
        c.gridy = y++;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 2;
        c.insets = new Insets(15, 10, 0, 10);
        contents.add((Component)snapshotsListL, c);
        this.openA = new AbstractAction(Bundle.SnapshotsWindowUI_actOpenSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descOpenSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotsWindowUI.openSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.exportA = new AbstractAction(Bundle.SnapshotsWindowUI_actExportSnapshot()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descExportSnapshot());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotsWindowUI.exportSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.compareA = new AbstractAction(Bundle.SnapshotsWindowUI_actCompareSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descCompareSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                List snapshots = SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1);
                SnapshotsWindowUI.compareSnapshots((Snapshot)snapshots.get(0), (Snapshot)snapshots.get(1));
            }
        };
        this.renameA = new AbstractAction(Bundle.SnapshotsWindowUI_actRenameSnapshot()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descRenameSnapshot());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Snapshot s = (Snapshot)SnapshotsWindowUI.this.snapshotsTable.getSelectedValue(1);
                SnapshotsWindowUI.renameSnapshot(s, SnapshotsWindowUI.this.snapshotsTableModel);
            }
        };
        this.deleteA = new AbstractAction(Bundle.SnapshotsWindowUI_actDeleteSnapshots()){
            {
                this.putValue("BTN_TOOLTIP", Bundle.SnapshotsWindowUI_descDeleteSnapshots());
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                SnapshotsWindowUI.this.deleteSnapshots(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        };
        this.snapshotsTable = new ProfilerTable(this.snapshotsTableModel, true, true, null){

            protected void populatePopup(final JPopupMenu popup, Object value, Object userValue) {
                popup.add(new JMenuItem(SnapshotsWindowUI.this.openA){
                    {
                        super(x0);
                        this.setFont(popup.getFont().deriveFont(1));
                    }
                });
                popup.add(new JMenuItem(SnapshotsWindowUI.this.exportA));
                popup.add(new JMenuItem(SnapshotsWindowUI.this.compareA));
                popup.add(new JMenuItem(SnapshotsWindowUI.this.renameA));
                popup.add(new JMenuItem(SnapshotsWindowUI.this.deleteA));
            }
        };
        this.snapshotsTable.providePopupMenu(true);
        this.snapshotsTable.setMainColumn(1);
        this.snapshotsTable.setDefaultSortOrder(SortOrder.ASCENDING);
        this.snapshotsTable.setSecondarySortColumn(1);
        this.snapshotsTable.setSortColumn(0);
        this.snapshotsTable.setFitWidthColumn(1);
        this.snapshotsTable.setDefaultColumnWidth(0, new JLabel((String)Bundle.SnapshotsWindowUI_colType()).getPreferredSize().width + 30);
        this.snapshotsTable.setColumnRenderer(0, (ProfilerRenderer)new LabelRenderer(){
            {
                this.setHorizontalAlignment(0);
            }

            public void setValue(Object value, int row) {
                if (value == null) {
                    this.setIcon(null);
                } else {
                    this.setIcon(Icons.getIcon((String)Snapshot.getIconName((Integer)value)));
                }
            }
        });
        this.snapshotsTable.setColumnRenderer(1, (ProfilerRenderer)new LabelRenderer(){
            private final Font plain = this.getFont().deriveFont(0);
            private final Font bold = this.plain.deriveFont(1);

            public void setValue(Object value, int row) {
                if (value == null) {
                    this.setText("");
                } else {
                    Snapshot s = (Snapshot)value;
                    this.setText(s.getDisplayName());
                    if (SnapshotsWindowUI.isOpen(s)) {
                        this.setFont(this.bold);
                    } else {
                        this.setFont(this.plain);
                    }
                }
            }
        });
        this.snapshotsTable.setColumnToolTips(new String[]{Bundle.SnapshotsWindowUI_ttpSnapshotType(), Bundle.SnapshotsWindowUI_ttpSnapshotName()});
        this.snapshotsTable.setDefaultAction(this.openA);
        this.snapshotsTable.setSelectionMode(2);
        this.snapshotsTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                SnapshotsWindowUI.this.updateButtons(SnapshotsWindowUI.this.snapshotsTable.getSelectedValues(1));
            }
        });
        c = new GridBagConstraints();
        c.gridy = y++;
        c.weightx = 1.0;
        c.weighty = 1.0;
        c.gridwidth = 0;
        c.anchor = 17;
        c.fill = 1;
        c.insets = new Insets(3, 10, 10, 10);
        contents.add((Component)new ProfilerTableContainer(this.snapshotsTable, true, null), c);
        this.setLayout(new BorderLayout());
        this.add(contents, "Center");
        JPanel actions = new JPanel(new ButtonsLayout());
        actions.setOpaque(true);
        actions.setBackground(UIUtils.getProfilerResultsBackground());
        actions.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        class ThinButton
        extends JButton {
            ThinButton(Action action, Icon icon) {
                super(action);
                this.setText(null);
                this.setIcon(icon);
                this.setToolTipText(action.getValue("BTN_TOOLTIP").toString());
                if (!UIUtils.isOracleLookAndFeel()) {
                    this.setOpaque(false);
                }
            }

            @Override
            public Dimension getMinimumSize() {
                Dimension d = super.getMinimumSize();
                d.width = 5;
                return d;
            }
        }
        actions.add(new ThinButton(this.openA, Icons.getIcon((String)"ProfilerIcons.SnapshotOpen")));
        actions.add(new ThinButton(this.exportA, Icons.getIcon((String)"GeneralIcons.Export")));
        actions.add(new ThinButton(this.compareA, Icons.getIcon((String)"ProfilerIcons.SnapshotsCompare")));
        actions.add(new ThinButton(this.renameA, Icons.getIcon((String)"GeneralIcons.Rename")));
        actions.add(new ThinButton(this.deleteA, Icons.getIcon((String)"ProfilerIcons.RunGC")));
        this.add(actions, "South");
        this.updateButtons(Collections.EMPTY_LIST);
    }

    private void updateButtons(List<Snapshot> selectedSnapshots) {
        int selected = selectedSnapshots.size();
        this.openA.setEnabled(selected > 0);
        this.exportA.setEnabled(selected > 0);
        this.compareA.setEnabled(selected == 2 && !selectedSnapshots.get(0).isHeapDump() && !selectedSnapshots.get(1).isHeapDump());
        this.renameA.setEnabled(selected == 1);
        this.deleteA.setEnabled(selected > 0);
    }

    private static boolean hasSnapshots(ProfilerSession session) {
        return true;
    }

    private static boolean isOpen(Snapshot s) {
        File f = FileUtil.toFile((FileObject)s.getFile());
        if (f == null) {
            return false;
        }
        if (s.isHeapDump()) {
            Set tcs = WindowManager.getDefault().getRegistry().getOpened();
            for (TopComponent tc : tcs) {
                if (!f.equals(tc.getClientProperty((Object)"nb.recent.file.path"))) continue;
                return true;
            }
        } else {
            LoadedSnapshot ls = ResultsManager.getDefault().findLoadedSnapshot(f);
            if (ls != null) {
                return true;
            }
        }
        return false;
    }

    private static void openSnapshots(final Collection<Snapshot> snapshots) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                for (Snapshot snapshot : snapshots) {
                    ResultsManager.getDefault().openSnapshot(snapshot.getFile());
                }
            }
        });
    }

    private static void exportSnapshots(Collection<Snapshot> snapshots) {
        FileObject[] files = new FileObject[snapshots.size()];
        int idx = 0;
        for (Snapshot snapshot : snapshots) {
            files[idx++] = snapshot.getFile();
        }
        ResultsManager.getDefault().exportSnapshots(files);
    }

    private static void compareSnapshots(final Snapshot snapshot1, final Snapshot snapshot2) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                FileObject file2;
                final FileObject file1 = snapshot1.getFile();
                if (CompareSnapshotsAction.areComparableSnapshots(file1, file2 = snapshot2.getFile())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ResultsManager.getDefault().compareSnapshots(file1, file2);
                        }
                    });
                } else {
                    ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgCannotCompareSnapshots());
                }
            }
        });
    }

    private static void renameSnapshot(final Snapshot snapshot, final AbstractTableModel model) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                final FileObject file = snapshot.getFile();
                String origName = file.getName();
                RenameSnapshotPanel panel = new RenameSnapshotPanel();
                panel.setSnapshotName(origName);
                DialogDescriptor dd = new DialogDescriptor((Object)panel, Bundle.SnapshotsWindowUI_capRenameSnapshot(), true, new Object[]{DialogDescriptor.OK_OPTION, DialogDescriptor.CANCEL_OPTION}, DialogDescriptor.OK_OPTION, 0, null, null);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
                if (dd.getValue() != DialogDescriptor.OK_OPTION) {
                    return;
                }
                final String newName = panel.getSnapshotName();
                if (!origName.equals(newName)) {
                    if (newName.isEmpty()) {
                        ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgNameEmpty());
                        SnapshotsWindowUI.renameSnapshot(snapshot, model);
                    } else {
                        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

                            @Override
                            public void run() {
                                FileLock lock = null;
                                try {
                                    lock = file.lock();
                                    LoadedSnapshot ls = ResultsManager.getDefault().findLoadedSnapshot(FileUtil.toFile((FileObject)file));
                                    file.rename(lock, newName, file.getExt());
                                    if (ls != null) {
                                        ls.setFile(FileUtil.toFile((FileObject)file));
                                    }
                                    snapshot.loadDetails();
                                    SwingUtilities.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            model.fireTableDataChanged();
                                        }
                                    });
                                }
                                catch (IOException e) {
                                    ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgRenameFailed(snapshot.getDisplayName()));
                                    e.printStackTrace();
                                    SnapshotsWindowUI.renameSnapshot(snapshot, model);
                                }
                                finally {
                                    if (lock != null) {
                                        lock.releaseLock();
                                    }
                                }
                            }
                        });
                    }
                }
            }
        });
    }

    private void deleteSnapshots(final Collection<Snapshot> snapshots) {
        SnapshotsWindowHelper.PROCESSOR.post(new Runnable(){

            @Override
            public void run() {
                if (ProfilerDialogs.displayConfirmation((String)Bundle.SnapshotsWindowUI_msgDeleteSnapshots(), (String)Bundle.SnapshotsWindowUI_capDeleteSnapshots())) {
                    ResultsManager rm = null;
                    for (Snapshot snapshot : snapshots) {
                        try {
                            if (!snapshot.isHeapDump()) {
                                LoadedSnapshot ls;
                                if (rm == null) {
                                    rm = ResultsManager.getDefault();
                                }
                                if ((ls = rm.findLoadedSnapshot(FileUtil.toFile((FileObject)snapshot.getFile()))) != null) {
                                    rm.closeSnapshot(ls);
                                }
                            }
                            DataObject.find((FileObject)snapshot.getFile()).delete();
                        }
                        catch (Throwable t) {
                            ProfilerDialogs.displayError((String)Bundle.SnapshotsWindowUI_msgDeleteFailed(snapshot.getDisplayName()));
                            t.printStackTrace();
                        }
                    }
                    SnapshotsWindowUI.this.refreshSnapshots();
                }
            }
        });
    }

    public void open() {
        Mode _mode;
        WindowManager wmanager = WindowManager.getDefault();
        if (wmanager.findMode((TopComponent)this) == null && (_mode = wmanager.findMode(Bundle.SnapshotsWindowUI_mode())) != null) {
            _mode.dockInto((TopComponent)this);
        }
        super.open();
    }

    protected void componentOpened() {
        super.componentOpened();
        this.refreshSnapshots();
        final boolean[] firstMainProject = new boolean[1];
        this.openProjectsListener = new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                PropertyChangeEvent event;
                if (!firstMainProject[0] && SnapshotsWindowUI.this.selector.getProject() == null && e.getSource() instanceof PropertyChangeEvent && "MainProject".equals((event = (PropertyChangeEvent)e.getSource()).getPropertyName()) && event.getOldValue() == null && event.getNewValue() instanceof Lookup.Provider) {
                    firstMainProject[0] = true;
                    SnapshotsWindowUI.this.selector.setProject((Lookup.Provider)event.getNewValue());
                    return;
                }
                SnapshotsWindowUI.this.selector.resetModel();
                SnapshotsWindowUI.this.selector.repaint();
            }
        };
        ProjectUtilities.addOpenProjectsListener((ChangeListener)this.openProjectsListener);
    }

    protected void componentClosed() {
        ProjectUtilities.removeOpenProjectsListener((ChangeListener)this.openProjectsListener);
        super.componentClosed();
    }

    public int getPersistenceType() {
        return 0;
    }

    protected String preferredID() {
        return ID;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    @Override
    protected Component defaultFocusOwner() {
        return this.snapshotsTable;
    }

    private static final class ButtonsLayout
    implements LayoutManager {
        private static final int HGAP = 2;
        private static final float MAX_WIDTH_FACTOR = 1.8f;

        private ButtonsLayout() {
        }

        @Override
        public void layoutContainer(Container parent) {
            int c = parent.getComponentCount();
            Insets insets = parent.getInsets();
            Dimension size = parent.getSize();
            size.width = Math.min(size.width, this.maximumLayoutSize((Container)parent).width);
            int x = insets.left;
            int y = insets.top;
            int w = size.width - x - insets.right - 2 * (c - 1);
            int h = size.height - y - insets.bottom;
            int m = w % c;
            w /= c;
            for (int i = 0; i < c; ++i) {
                int o = i < m ? 1 : 0;
                parent.getComponent(i).setBounds(x, y, w + o, h);
                x += w + o + 2;
            }
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            int prefw = 0;
            int prefh = 0;
            for (Component c : parent.getComponents()) {
                Dimension pref = c.getPreferredSize();
                prefw += pref.width;
                prefh = Math.max(prefh, pref.height);
            }
            prefw += 2 * (parent.getComponentCount() - 1);
            Insets i = parent.getInsets();
            return new Dimension(prefw += i.left + i.right, prefh += i.top + i.bottom);
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            int minw = 0;
            int minh = 0;
            for (Component c : parent.getComponents()) {
                Dimension min = c.getMinimumSize();
                minw += min.width;
                minh = Math.max(minh, min.height);
            }
            return new Dimension(minw += 2 * (parent.getComponentCount() - 1), minh);
        }

        private Dimension maximumLayoutSize(Container parent) {
            int maxw = 0;
            int maxh = 0;
            for (Component c : parent.getComponents()) {
                Dimension pref = c.getPreferredSize();
                maxw = (int)((float)maxw + (float)pref.height * 1.8f);
                maxh = Math.max(maxh, pref.height);
            }
            maxw += 2 * (parent.getComponentCount() - 1);
            Insets i = parent.getInsets();
            return new Dimension(maxw += i.left + i.right, maxh += i.top + i.bottom);
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }
    }

    private static final class RenameSnapshotPanel
    extends JPanel {
        private JTextField textField;

        RenameSnapshotPanel() {
            this.initComponents();
        }

        String getSnapshotName() {
            return this.textField.getText().trim();
        }

        void setSnapshotName(String text) {
            this.textField.setText(text);
            this.textField.selectAll();
        }

        private void initComponents() {
            JLabel textLabel = new JLabel();
            Mnemonics.setLocalizedText((JLabel)textLabel, (String)Bundle.SnapshotsWindowUI_lblNewFile());
            textLabel.setAlignmentX(0.0f);
            this.textField = new JTextField();
            textLabel.setLabelFor(this.textField);
            this.textField.setPreferredSize(new Dimension(350, this.textField.getPreferredSize().height));
            this.textField.requestFocus();
            this.textField.setAlignmentX(0.0f);
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.insets = new Insets(15, 10, 5, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)textLabel, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.insets = new Insets(0, 10, 15, 10);
            gridBagConstraints.anchor = 17;
            this.add((Component)this.textField, gridBagConstraints);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 2;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.add((Component)new JPanel(), gridBagConstraints);
            this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputPanel"));
            this.textField.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(NotifyDescriptor.class, (String)"ACSD_InputField"));
        }
    }

    private static abstract class Snapshot
    implements Comparable {
        private final FileObject fo;
        private String displayName;
        private boolean customName;
        private long timestamp;
        private int snapshotType;
        private boolean isHeapDump;

        Snapshot(FileObject fo) {
            this.fo = fo;
            this.loadDetails();
        }

        abstract boolean alternativeSorting();

        public String getDisplayName() {
            return this.displayName;
        }

        public int getSnapshotType() {
            return this.snapshotType;
        }

        public static String getIconName(int type) {
            switch (type) {
                case 1: {
                    return "ProfilerIcons.Cpu";
                }
                case 2: {
                    return "ProfilerIcons.Memory";
                }
                case 3: {
                    return "ProfilerIcons.SnapshotThreads";
                }
                case 4: {
                    return "ProfilerIcons.HeapDump";
                }
                case 5: {
                    return "ProfilerIcons.WindowSql";
                }
            }
            return null;
        }

        public FileObject getFile() {
            return this.fo;
        }

        public boolean isHeapDump() {
            return this.isHeapDump;
        }

        void loadDetails() {
            String fileName = this.fo.getName();
            if (this.fo.getExt().equalsIgnoreCase("hprof")) {
                this.snapshotType = 4;
                this.displayName = ResultsManager.getDefault().getHeapDumpDisplayName(fileName);
                this.isHeapDump = true;
            } else {
                int type = ResultsManager.getDefault().getSnapshotType(this.fo);
                this.snapshotType = type == 1 ? 1 : (type == 32 ? 5 : 2);
                this.displayName = ResultsManager.getDefault().getSnapshotDisplayName(fileName, type);
                this.isHeapDump = false;
            }
            this.customName = fileName.equals(this.displayName);
            if (!this.customName) {
                String _timestamp = fileName.substring(fileName.lastIndexOf(45));
                try {
                    this.timestamp = Long.parseLong(_timestamp);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
        }

        public boolean equals(Object o) {
            return this.fo.equals(((Snapshot)o).fo);
        }

        public int hashCode() {
            return this.fo.hashCode();
        }

        public int compareTo(Object o) {
            Snapshot s = (Snapshot)o;
            if (this.alternativeSorting()) {
                if (this.customName) {
                    if (!s.customName) {
                        return -1;
                    }
                    return Collator.getInstance().compare(this.getDisplayName(), s.getDisplayName());
                }
                if (s.customName) {
                    return 1;
                }
                return Long.compare(this.timestamp, s.timestamp);
            }
            return Collator.getInstance().compare(this.getDisplayName(), s.getDisplayName());
        }
    }
}

