/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.ui.jdbc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.graalvm.visualvm.lib.jfluid.ProfilerClient;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.results.CCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.RuntimeCCTNode;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcCCTProvider;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcResultsSnapshot;
import org.graalvm.visualvm.lib.ui.jdbc.LiveJDBCView;
import org.openide.util.Lookup;

public class LiveJDBCViewUpdater {
    private static final int MIN_UPDATE_DIFF = 900;
    private static final int MAX_UPDATE_DIFF = 1400;
    private CCTHandler handler;
    private final LiveJDBCView jdbcView;
    private final ProfilerClient client;
    private volatile boolean paused;
    private volatile boolean forceRefresh;

    public LiveJDBCViewUpdater(LiveJDBCView jdbcView, ProfilerClient client) {
        this.jdbcView = jdbcView;
        this.client = client;
    }

    public void setPaused(boolean paused) {
        this.paused = paused;
    }

    public void setForceRefresh(boolean forceRefresh) {
        this.forceRefresh = forceRefresh;
    }

    public void update() throws ClientUtils.TargetAppOrVMTerminated {
        if (this.handler == null) {
            this.handler = CCTHandler.registerUpdater(this);
        }
        if (this.forceRefresh || !this.paused && this.jdbcView.getLastUpdate() + 1400L < System.currentTimeMillis()) {
            this.client.forceObtainedResultsDump(true);
        }
    }

    public void cleanup() {
        if (this.handler != null) {
            this.handler.unregisterUpdater(this);
        }
        this.handler = null;
    }

    private void updateData() throws ClientUtils.TargetAppOrVMTerminated {
        if (!this.forceRefresh && (this.paused || this.jdbcView.getLastUpdate() + 900L > System.currentTimeMillis())) {
            return;
        }
        JdbcResultsSnapshot data = this.client.getStatus().getInstrMethodClasses() == null ? null : this.client.getJdbcProfilingResultsSnapshot(false);
        this.jdbcView.setData(data);
        this.forceRefresh = false;
    }

    private void resetData() {
        this.jdbcView.resetData();
    }

    public static class CCTHandler
    implements JdbcCCTProvider.Listener {
        private final List<LiveJDBCViewUpdater> updaters = new ArrayList<LiveJDBCViewUpdater>();

        public static CCTHandler registerUpdater(LiveJDBCViewUpdater updater) {
            CCTHandler handler = (CCTHandler)Lookup.getDefault().lookup(CCTHandler.class);
            if (handler.updaters.isEmpty()) {
                Collection jdbcCCTProviders = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
                assert (!jdbcCCTProviders.isEmpty());
                for (JdbcCCTProvider provider : jdbcCCTProviders) {
                    provider.addListener((CCTProvider.Listener)handler);
                }
            }
            handler.updaters.add(updater);
            return handler;
        }

        public void unregisterUpdater(LiveJDBCViewUpdater updater) {
            this.updaters.remove(updater);
            if (this.updaters.isEmpty()) {
                Collection jdbcCCTProviders = Lookup.getDefault().lookupAll(JdbcCCTProvider.class);
                assert (!jdbcCCTProviders.isEmpty());
                for (JdbcCCTProvider provider : jdbcCCTProviders) {
                    provider.removeListener((CCTProvider.Listener)this);
                }
            }
        }

        public final void cctEstablished(RuntimeCCTNode appRootNode, boolean empty) {
            if (!empty) {
                for (LiveJDBCViewUpdater updater : this.updaters) {
                    try {
                        updater.updateData();
                    }
                    catch (ClientUtils.TargetAppOrVMTerminated ex) {
                        Logger.getLogger(LiveJDBCView.class.getName()).log(Level.FINE, null, ex);
                    }
                }
            }
        }

        public final void cctReset() {
            for (LiveJDBCViewUpdater updater : this.updaters) {
                updater.resetData();
            }
        }
    }
}

