/*
 * Decompiled with CFR 0.152.
 */
package org.openjdk.jmc.common.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.openjdk.jmc.common.item.IAggregator;
import org.openjdk.jmc.common.item.IAttribute;
import org.openjdk.jmc.common.item.IItemFilter;
import org.openjdk.jmc.common.item.IItemQuery;

public class ItemQueryBuilder {
    private ItemQuery query;

    private ItemQueryBuilder(IItemFilter filter) {
        this.query = new ItemQuery(filter);
    }

    private ItemQuery getQuery() {
        if (this.query == null) {
            throw new IllegalStateException("Query already built. ItemQueryBuilder cannot be reused.");
        }
        return this.query;
    }

    public ItemQueryBuilder select(IAttribute<?> ... attributes) {
        for (IAttribute<?> attribute : attributes) {
            this.select(attribute);
        }
        return this;
    }

    public ItemQueryBuilder select(IAggregator<?, ?> ... aggregators) {
        for (IAggregator<?, ?> aggregator : aggregators) {
            this.select(aggregator);
        }
        return this;
    }

    public ItemQueryBuilder select(IAttribute<?> attribute) {
        this.getQuery().fields.add(attribute);
        return this;
    }

    public ItemQueryBuilder select(IAggregator<?, ?> aggregator) {
        this.getQuery().aggregators.add(aggregator);
        return this;
    }

    public ItemQueryBuilder groupBy(IAttribute<?> attribute) {
        this.getQuery().groupBy = attribute;
        return this;
    }

    public static ItemQueryBuilder fromWhere(IItemFilter filter) {
        return new ItemQueryBuilder(filter);
    }

    public IItemQuery build() {
        ItemQuery q = this.query;
        this.query = null;
        q.fields = Collections.unmodifiableCollection(q.fields);
        q.aggregators = Collections.unmodifiableCollection(q.aggregators);
        return q;
    }

    private static class ItemQuery
    implements IItemQuery {
        private final IItemFilter filter;
        private Collection<IAttribute<?>> fields = new ArrayList();
        private Collection<IAggregator<?, ?>> aggregators = new ArrayList();
        private IAttribute<?> groupBy;

        ItemQuery(IItemFilter filter) {
            this.filter = filter;
        }

        @Override
        public IItemFilter getFilter() {
            return this.filter;
        }

        @Override
        public Collection<IAttribute<?>> getAttributes() {
            return this.fields;
        }

        @Override
        public IAttribute<?> getGroupBy() {
            return this.groupBy;
        }

        @Override
        public Collection<IAggregator<?, ?>> getAggregators() {
            return this.aggregators;
        }
    }
}

